//
//  TWNavigationVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/22.
//

import UIKit
import YTBaseKit

class TWNavigationVc: UINavigationController {

    override func viewDidLoad() {
        super.viewDidLoad()

        //黑体导航栏
        if #available(iOS 15.0, *) {
            let appearance = UINavigationBarAppearance()
            appearance.shadowColor = UIColor(hexString: "ffffff")
            appearance.backgroundColor = UIColor(hexString: "ffffff")
            appearance.titleTextAttributes = [NSAttributedString.Key.foregroundColor: UIColor(hexString: "333333"), NSAttributedString.Key.font:UIFont(name: "PingFangSC-Medium", size: 17)!]
            navigationBar.standardAppearance = appearance
            navigationBar.scrollEdgeAppearance = appearance
            navigationBar.tintColor = UIColor(hexString: "333333")
            
            let tabBarAppearance = UITabBarAppearance()
            tabBarAppearance.backgroundEffect = nil;
            tabBarAppearance.backgroundColor = UIColor(hexString: "ffffff")

            self.tabBarController?.tabBar.scrollEdgeAppearance = tabBarAppearance
            self.tabBarController?.tabBar.standardAppearance = tabBarAppearance
        } else {
            // item
            navigationBar.tintColor = UIColor(hexString: "333333")
            // 背景
            navigationBar.barTintColor = UIColor(hexString: "ffffff")
            // 标题
            let titleAtt:[NSAttributedString.Key:Any] = [NSAttributedString.Key.font:UIFont(name: "PingFangSC-Medium", size: 17)!,NSAttributedString.Key.foregroundColor:UIColor(hexString: "333333")]
            navigationBar.titleTextAttributes = titleAtt
        }
    }

}
