//
//  TWTabBarVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/22.
//

import UIKit

class TWTabBarVc: UITabBarController {

    override func viewDidLoad() {
        super.viewDidLoad()

        setupSubViewControllers()
    }

    
    func setupSubViewControllers() {

        let vc1 = UIStoryboard(name: "Home", bundle: nil).instantiateViewController(withIdentifier: "HomePagingVc") as! HomePagingVc
        vc1.tabBarItem.title = "首页".languageString()
        vc1.tabBarItem.image = UIImage(named: "icon_home_nor")
        vc1.tabBarItem.selectedImage = UIImage(named: "icon_home_sel")!.withRenderingMode(UIImage.RenderingMode.alwaysOriginal)
        
        vc1.tabBarItem.setTitleTextAttributes([NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "666666")], for: .normal)
        vc1.tabBarItem.setTitleTextAttributes([NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "478BFF")], for: .selected)
        vc1.tabBarItem.setTitleTextAttributes([NSAttributedString.Key.foregroundColor :UIColor.init(hexString: "478BFF")], for: .highlighted)
        
        if #available(iOS 13.0, *) {
            let tabBarAppearance = UITabBarAppearance()
            tabBarAppearance.backgroundEffect = nil;
            tabBarAppearance.backgroundColor = UIColor(hexString: "ffffff")
            tabBarAppearance.stackedLayoutAppearance.normal.titleTextAttributes = [NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "666666")]
            tabBarAppearance.stackedLayoutAppearance.selected.titleTextAttributes = [NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "478BFF")]
            vc1.tabBarItem.standardAppearance = tabBarAppearance
            
        } else {
            // Fallback on earlier versions
        }
        
        let nav1 = TWNavigationVc.init(rootViewController: vc1)



//      let performanceNavigationVC = UIStoryboard(name: "Order", bundle: nil).instantiateInitialViewController() as! TWNavigationVc
        
        let vc2 = UIStoryboard.init(name: "Order", bundle: nil).instantiateViewController(withIdentifier: "OrderHomeVc") as! OrderHomeVc
        
        vc2.tabBarItem.title = "工作台".languageString()
        vc2.tabBarItem.image = UIImage(named: "icon_staging_nor")
        vc2.tabBarItem.selectedImage = UIImage(named: "icon_staging_sel")!.withRenderingMode(UIImage.RenderingMode.alwaysOriginal)
        vc2.tabBarItem.setTitleTextAttributes([NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "666666")], for: .normal)
        vc2.tabBarItem.setTitleTextAttributes([NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "478BFF")], for: .selected)
        vc2.tabBarItem.setTitleTextAttributes([NSAttributedString.Key.foregroundColor :UIColor.init(hexString: "478BFF")], for: .highlighted)
        
        if #available(iOS 13.0, *) {
            let tabBarAppearance = UITabBarAppearance()
            tabBarAppearance.backgroundEffect = nil;
            tabBarAppearance.backgroundColor = UIColor(hexString: "ffffff")
            tabBarAppearance.stackedLayoutAppearance.normal.titleTextAttributes = [NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "666666")]
            tabBarAppearance.stackedLayoutAppearance.selected.titleTextAttributes = [NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "478BFF")]
            vc2.tabBarItem.standardAppearance = tabBarAppearance
            
        } else {
            // Fallback on earlier versions
        }
     
        
        let nav2 = TWNavigationVc.init(rootViewController: vc2)
        
        
//        let vc3 = UIStoryboard.init(name: "Service", bundle: nil).instantiateInitialViewController() as! TWNavigationVc
        
        let vc3 = UIStoryboard.init(name: "Service", bundle: nil).instantiateViewController(withIdentifier: "ServiceHomeVc") as! ServiceHomeVc
        vc3.tabBarItem.title = "支持".languageString()
        vc3.tabBarItem.image = UIImage(named: "icon_support_nor")
        vc3.tabBarItem.selectedImage = UIImage(named: "icon_support_sel")!.withRenderingMode(UIImage.RenderingMode.alwaysOriginal)
        vc3.tabBarItem.setTitleTextAttributes([NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "666666")], for: .normal)
        vc3.tabBarItem.setTitleTextAttributes([NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "478BFF")], for: .selected)
        vc3.tabBarItem.setTitleTextAttributes([NSAttributedString.Key.foregroundColor :UIColor.init(hexString: "478BFF")], for: .highlighted)
        if #available(iOS 13.0, *) {
            let tabBarAppearance = UITabBarAppearance()
            tabBarAppearance.backgroundEffect = nil;
            tabBarAppearance.backgroundColor = UIColor(hexString: "ffffff")
            tabBarAppearance.stackedLayoutAppearance.normal.titleTextAttributes = [NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "666666")]
            tabBarAppearance.stackedLayoutAppearance.selected.titleTextAttributes = [NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "478BFF")]
            vc3.tabBarItem.standardAppearance = tabBarAppearance
            
        } else {
            // Fallback on earlier versions
        }
        let nav3 = TWNavigationVc.init(rootViewController: vc3)
        
        
        let vc4 = UIStoryboard(name: "Mine", bundle: nil).instantiateViewController(withIdentifier: "MineHomeVc") as! MineHomeVc
        vc4.tabBarItem.title = "我的".languageString()
        vc4.tabBarItem.setTitleTextAttributes([NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "666666")], for: .normal)
        vc4.tabBarItem.setTitleTextAttributes([NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "478BFF")], for: .selected)
        vc4.tabBarItem.setTitleTextAttributes([NSAttributedString.Key.foregroundColor :UIColor.init(hexString: "478BFF")], for: .highlighted)
        vc4.tabBarItem.image = UIImage(named: "icon_mine_nor")
        vc4.tabBarItem.selectedImage = UIImage(named: "icon_mine_sel")!.withRenderingMode(UIImage.RenderingMode.alwaysOriginal)
        if #available(iOS 13.0, *) {
            let tabBarAppearance = UITabBarAppearance()
            tabBarAppearance.backgroundEffect = nil;
            tabBarAppearance.backgroundColor = UIColor(hexString: "ffffff")
            tabBarAppearance.stackedLayoutAppearance.normal.titleTextAttributes = [NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "666666")]
            tabBarAppearance.stackedLayoutAppearance.selected.titleTextAttributes = [NSAttributedString.Key.foregroundColor : UIColor.init(hexString: "478BFF")]
            vc4.tabBarItem.standardAppearance = tabBarAppearance
            
        } else {
            // Fallback on earlier versions
        }
        let nav4 = TWNavigationVc.init(rootViewController: vc4)
        
        viewControllers = [nav1,nav2,nav3, nav4]
    }
    
    
    func sendJPush(){
        JPUSHService.registrationIDCompletionHandler { [weak self] (resuleCode, idStr) in
            guard let weakSelf = self else { return }
            guard let curIdStr = idStr else { return }
            if curIdStr.isEmpty { return }
            // 上传推送token
            DispatchQueue.global().async { () in
                weakSelf.requestUpdatetoken(idStr: curIdStr)
            }
        }
    }
    
    
    func requestUpdatetoken(idStr:String){
        
    }
    

}
