//
//  TWViewController+.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/22.
//

import UIKit
import Foundation

extension UIViewController {

    //主题返回按钮黑色
    @objc func setNavigationBackButton(){
        let leftButton = UIButton(type: UIButton.ButtonType.custom)
        leftButton.frame = CGRect(x: 0, y: 0, width: 20, height: 20)
        leftButton.imageEdgeInsets = UIEdgeInsets(top: 0, left: -10, bottom: 0, right: 0)
        leftButton.setImage(UIImage(named: "ico_nav_back"), for: .normal);
        leftButton.addTarget(self, action: #selector(UIViewController.popVC), for: UIControl.Event.touchDown)
        self.navigationItem.leftBarButtonItem = UIBarButtonItem(customView: leftButton) ;
    }
    
    @objc func popVC(){
        self.navigationController!.popViewController(animated: true )
    }
    
    //打开外部网页
    func toOpenHtml(_ url:String){
        let urlString = url
        guard let requestUrl = URL(string: urlString) else {
            self.promptInformation("网页出错了".languageString())
            return
        }
        if #available(iOS 10, *) {
            UIApplication.shared.open(requestUrl, options: [:],
                                      completionHandler: {
                (success) in
                debugPrint("Open \(url): \(success)")
            })
        } else {
            let success = UIApplication.shared.openURL(requestUrl)
            debugPrint("Open \(url): \(success)")
        }
    }
    
    //电话
    func callPhone(_ phone:String,orderid:String=""){
        let mobile = "tel://" + phone
        guard let phoneUrl = URL(string: mobile) else {
            self.promptInformation("拨打的电话格式错误~".languageString())
            return
        }
        if orderid == ""{
            UIApplication.shared.open(phoneUrl, options: [:], completionHandler: nil)
        }
        else{
            //记录电话
            var paramDict = [String:Any]()
            paramDict["orderId"] = orderid
            
            let cNet = TWOCNetwork(url: "/app/v2/orderDo/saveUserDialRecord",andParam: paramDict)
            cNet.successCall = { (result) in
                UIApplication.shared.open(phoneUrl, options: [:], completionHandler: nil)
            }
            cNet.failCall = {(errorTag,errorStr) in
    
            }
            cNet.postRequest()
        }
    }
    
    //电话
    func callUserPhone(_ phone:String, orderId:String = ""){
        let mobile = "tel://" + phone
        guard let phoneUrl = URL(string: mobile) else {
            self.promptInformation("拨打的电话格式错误~".languageString())
            return
        }
        UIApplication.shared.open(phoneUrl, options: [:], completionHandler: nil)
        if !orderId.isEmpty {
            saveUserDialRecord(orderId: orderId)
        }
    }
        
    func promptInformation(_ infoStr:String){
        SVProgressHUD.showInfo(withStatus: infoStr, maskType: .custom)
     }
}

extension UIViewController {
    func saveUserDialRecord(orderId:String) {
        var par:[String:Any] = [:]
        par["orderId"] = orderId
        let cNet = TWOCNetwork(url: "/app/v2/orderDo/saveUserDialRecord",andParam: par)
        cNet.successCall = {(result) in
            
        }
        cNet.failCall = {(errorTag,errorStr) in
//            hud_error(errorStr)
        }
        cNet.postRequest()
    }
}
