//
//  Cell_FinishItemCode.swift
//  Service
//
//  Created by Jan on 2023/8/2.
//  Copyright © 2023 yus. All rights reserved.
//

import UIKit

class Cell_FinishItemCode: UITableViewCell {
    @IBOutlet weak var btn_scan: UIButton!
    @IBOutlet weak var tf_code: UITextField!
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
    
        tf_code.addTarget(self, action: #selector(self.fieldChanged(theF:)), for: .editingChanged)
        tf_code.addTarget(self, action: #selector(self.fieldChangedEnd(theF:)), for: .editingDidEnd)
        
        tf_code.placeholder = "请输入条码".languageString()
    }

    @IBAction func scanAction(_ sender: UIButton) {
        callBack?("扫码")
    }
    
    @objc func fieldChanged(theF:UITextField)  {
        callBack?((UIControl.Event.editingChanged,theF.text ?? ""))
    }
    
    @objc func fieldChangedEnd(theF:UITextField)  {
        callBack?((UIControl.Event.editingDidEnd,theF.text ?? ""))
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_FinishItemCode: TCCell_RowCellUpdateProtocol {
    // title宽度、value、placeholder  正则、键盘类型
    typealias DataSource = (String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        tf_code.isEnabled = data.canEdit
    }
    
    func row_update(dataSource data: (String,String)) {
        tf_code.text = data.0
        tf_code.placeholder = data.1
    }
    
}
