//
//  Cell_OrderCreatItemClass.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/29.
//

import UIKit

class Cell_OrderCreatItemClass: UITableViewCell {
    //产品类别

    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var classSelectBtn: UIButton!
    @IBOutlet weak var classNameLb: UILabel!
    @IBOutlet weak var maxClassNameLb: UILabel!
    @IBOutlet weak var maxClassBtn: UIButton!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        lab_title.text = "产品类别:".languageString()
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func selecteMinAction(_ sender: UIButton) {
        callBack?("小类")
    }
    
    
    @IBAction func selecteMaxAction(_ sender: UIButton) {
        callBack?("大类")
    }
}



extension Cell_OrderCreatItemClass: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (String,String)) {
        let bigitemcatname = data.0
        let smallitemcatname = data.1
        
        classNameLb.text = smallitemcatname == "" ? "选择小类".languageString() : smallitemcatname
        maxClassNameLb.text = bigitemcatname == "" ? "选择大类".languageString() : bigitemcatname
    }
    
}
