//
//  Cell_OrderCreatSelectUserType.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/29.
//

import UIKit

class Cell_OrderCreatSelectUserType: UITableViewCell {
    
    @IBOutlet weak var lab_1: UILabel!
    @IBOutlet weak var lab_2: UILabel!
    @IBOutlet weak var selectBtn1: UIButton!
    @IBOutlet weak var selectBtn2: UIButton!
    @IBOutlet weak var backgView: UIView!
    var callBack: TCRowCallBack?
    
     override func awakeFromNib() {
        backgView.layer.cornerRadius = 20
        backgView.layer.masksToBounds = true
         
         lab_1.text = "普通用户".languageString()
         lab_2.text = "工程用户".languageString()
    }
    
    @IBAction func selectBtnClick(_ sender: UIButton) {
        selectBtn1.setImage(UIImage.init(named: "hep_radiobox_selected"), for: .normal)
        selectBtn2.setImage(UIImage.init(named: "hep_radiobox_normal"), for: .normal)
        
        if (callBack != nil) {
            callBack?(0)
        }
    }
    
    @IBAction func selectBtn2Click(_ sender: UIButton) {
        selectBtn2.setImage(UIImage.init(named: "hep_radiobox_selected"), for: .normal)
        selectBtn1.setImage(UIImage.init(named: "hep_radiobox_normal"), for: .normal)
        
        if (callBack != nil) {
            callBack?(2)
        }
    }
}


extension Cell_OrderCreatSelectUserType: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (String)) {
       let usertype = data
        if usertype == "0" {
            self.selectBtn1.setImage(UIImage.init(named: "hep_radiobox_selected"), for: .normal)
            self.selectBtn2.setImage(UIImage.init(named: "hep_radiobox_normal"), for: .normal)
        }else{
            self.selectBtn2.setImage(UIImage.init(named: "hep_radiobox_selected"), for: .normal)
            self.selectBtn1.setImage(UIImage.init(named: "hep_radiobox_normal"), for: .normal)
        }
    }
    
}
