//
//  Cell_OrderCreatSwitch.swift
//  VattiCSS
//
//  Created by WZR on 2024/3/12.
//

import UIKit

class Cell_OrderCreatSwitch: UITableViewCell {

    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var btn_item1: UIButton!
    @IBOutlet weak var btn_item2: UIButton!
    
    @IBOutlet weak var lineView: UIView!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        
        btn_item1.imageEdgeInsets = UIEdgeInsets(top: 0, left: -2, bottom: 0, right: 0)
        btn_item2.imageEdgeInsets = UIEdgeInsets(top: 0, left: -2, bottom: 0, right: 0)
    }

    @IBAction func clickAction(_ sender: UIButton) {
        callBack?(sender.tag)
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}

extension Cell_OrderCreatSwitch: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,Int,[String],[Int])
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
        
        lineView.isHidden = !data.showLineView
    }
    
    func row_update(dataSource data: (String,Int,[String],[Int])) {
        btn_item2.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
        btn_item1.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
        
        lab_title.text = data.0
        let type = data.1
        
        for (index,item) in data.2.enumerated() {
            switch index {
            case 0:
                btn_item1.setTitle(item, for: .normal)
                btn_item1.tag = data.3[index]
                
                if type == data.3[index]{
                    btn_item1.setImage(UIImage(named: "hep_radiobox_selected"), for: .normal)
                    btn_item2.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
                }
                break
            case 1:
                btn_item2.setTitle(item, for: .normal)
                btn_item2.tag = data.3[index]
                
                if type == data.3[index]{
                    btn_item2.setImage(UIImage(named: "hep_radiobox_selected"), for: .normal)
                    btn_item1.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
                }
                break
            default:
                break
            }
        }
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}


