//
//  Cell_OrderFinishImages.swift
//  Service
//
//  Created by Jan on 2023/8/4.
//  Copyright © 2023 yus. All rights reserved.
//

import UIKit

class Cell_OrderFinishImages: UITableViewCell {
    @IBOutlet weak var collectionView: UICollectionView!
    var flowLayout:UICollectionViewFlowLayout!
    var scanImages = [M_FinishOrder.ScanImageModel]()
    var callBack: TCRowCallBack?
    var canEdit = true
    override func awakeFromNib() {
        super.awakeFromNib()
        
        self.collectionView.delegate =  self
        self.collectionView.dataSource =  self
        self.collectionView.showsVerticalScrollIndicator = false
        self.collectionView.showsHorizontalScrollIndicator = false
        self.collectionView.isScrollEnabled = false
        
        self.collectionView.backgroundColor = .white
        
        //初始化flow布局
        flowLayout = UICollectionViewFlowLayout()
        flowLayout.itemSize = CGSize(width: KW(width: 75), height: 120)
       
        self.collectionView.collectionViewLayout = flowLayout
        
        // 注册CollectionViewCell
        self .collectionView!.register( UINib (nibName: "Cell_OrderFinishImageItem" , bundle: nil ),
                                             forCellWithReuseIdentifier:  "Cell_OrderFinishImageItem" )
    }
    
    func makeattributed(text:String) -> NSMutableAttributedString {
          let attributedStrM : NSMutableAttributedString = NSMutableAttributedString()
          //内容
        let star : NSAttributedString = NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor  : UIColor(hexString: "F33232"), NSAttributedString.Key.font : UIFont.systemFont(ofSize: 12)])
          
           let content : NSAttributedString = NSAttributedString(string: text, attributes: [NSAttributedString.Key.foregroundColor  : UIColor.init(red: 153/256.0, green: 153/256.0, blue: 153/256.0, alpha: 1.0), NSAttributedString.Key.font : UIFont.systemFont(ofSize: 12)])
    
          attributedStrM.append(star)
          attributedStrM.append(content)
          
          return attributedStrM
      }
}


extension Cell_OrderFinishImages: TCCell_RowCellUpdateProtocol {
    // title宽度、value、placeholder  正则、键盘类型
    typealias DataSource = ([M_FinishOrder.ScanImageModel])
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        self.canEdit = data.canEdit
    }
    
    func row_update(dataSource data: ([M_FinishOrder.ScanImageModel])) {
        scanImages = data
        
        self.collectionView.reloadData()
    }
    
}

extension Cell_OrderFinishImages:UICollectionViewDelegate,UICollectionViewDataSource {
    //返回collectionView的单元格数量
    func collectionView(_ collectionView:  UICollectionView ,
                        numberOfItemsInSection section:  Int ) ->  Int  {
        return  scanImages.count
    }
    
    //返回对应的单元格
    func  collectionView(_ collectionView:  UICollectionView ,
                        cellForItemAt indexPath:  IndexPath ) ->  UICollectionViewCell  {
     let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "Cell_OrderFinishImageItem", for: indexPath) as! Cell_OrderFinishImageItem
     
        let model = scanImages[indexPath.item]
        
        let imgUrl = kGetServerPicUrl(model.pic)
        let imgTitle = model.picname
        if model.ismust == "1" {
            cell.titleLab.attributedText = makeattributed(text: imgTitle)
        } else {
            cell.titleLab.text = imgTitle
        }
       
        if imgUrl == "" {
            cell.imageView.image = UIImage.init(named: "")
            cell.addBtn.isHidden = false
            cell.deleteBtn.isHidden = true
         
       }else{
         cell.addBtn.isHidden = true
         cell.deleteBtn.isHidden = false
         cell.imageView.sd_setImage(with: URL.init(string: imgUrl))
         cell.deleteBtn.isHidden = !canEdit //是不是完工详情
        //删除
         cell.callBack = { (t)  in
             self.callBack?(("delete",indexPath.row))
         }
       
       }
        
        return  cell
    }

  func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumLineSpacingForSectionAt section: Int) -> CGFloat {
       return 0.1
   }
   
   func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumInteritemSpacingForSectionAt section: Int) -> CGFloat {
       return 0.1
   }

   func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
       return CGSize(width: KW(width: 75), height: 120)
   }

   func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
       let model = scanImages[indexPath.item]
       let imgUrl = kGetServerPicUrl(model.pic)
       if imgUrl == "" {
          //添加图片
           self.callBack?(("add",indexPath.row))
       }else{
          //查看图片
           self.callBack?(imgUrl)
       }
      
    }
    
}
