//
//  BarcodeCheckVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/31.
//

import UIKit
import MJRefresh

class BarcodeCheckVc: UIViewController {
    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var tf_search: UITextField!
    @IBOutlet weak var btn_code: UIButton!
    var vm = BarcodeCheckVm()
    //获取数据
    var getDataUrl = "app/v2/multiplex/barcodeHistorySearch"
    var searchValue = ""
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }
    
    @IBAction func editingDidEnd(_ sender: UITextField) {
        searchValue = sender.txt
        self.headerRefresh()
    }
    
    @IBAction func searchOrders(_ sender: UIButton) {
        let qrVC = QRViewController()
        qrVC.configResultCall { code, errorStr in
            if errorStr != "" {
                CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~".languageString())
                return
            }
            self.searchValue = code ?? ""
            self.headerRefresh()
        }
        let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
        qrNavigationC.modalPresentationStyle = .overFullScreen
        qrNavigationC.modalTransitionStyle = .crossDissolve
        CD.visibleVC?.present(qrNavigationC, animated: true, completion: nil)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.title = "设备追溯".languageString()
        setNavigationBackButton()
        configTableView()
        
        btn_code.imageEdgeInsets = UIEdgeInsets(top: 0, left: -8, bottom: 0, right: 0)
    }
    
    func configTableView() {
        self.tableView.backgroundColor = UIColor(hexString: "f8f8f8")
        self.view.backgroundColor = UIColor(hexString: "f8f8f8")
        
        if #available(iOS 15.0, *) {
            tableView.sectionHeaderTopPadding = 0
        }
        tableView.delegate = self
        tableView.dataSource = self
        tableView.separatorStyle = .none
        vm.callback = {
            self.tableView.reloadData()
        }
        
        let header = MJRefreshNormalHeader()
        header.stateLabel.textColor = UIColor(hexString: "999999")
        header.setRefreshingTarget(self, refreshingAction: #selector(headerRefresh))
        tableView.mj_header = header
    }

}


//网络请求
extension BarcodeCheckVc{
    //mark refresh
    @objc func headerRefresh(){
        requestData()
    }
    
    func requestData(){
        if searchValue == "" {
            self.tableView.mj_header.endRefreshing()
           return
        }
        
        var paramDict = [String:Any]()
        paramDict["barcode"] = searchValue

        let cNet = TWOCNetwork(url: getDataUrl,andParam: paramDict)
        cNet.successCall = { [weak self] (result) in
            guard let weakSelf = self else { return }
            weakSelf.tableView.mj_header.endRefreshing()
            
            if let data = result["data"] as? [String:Any] {
                if let datas = data["datas"] as? [[String:Any]] {
                    if datas.count > 0 {
                        let dict = datas[0]
                        weakSelf.vm.codeDict = dict
                        weakSelf.vm.makeForms()
                    }
                    else{
                        hud_info("未找到设备~".languageString())
                    }
                }
            }else{
                hud_error("请求出错了，请稍后再试~".languageString())
            }
        }
        cNet.failCall = {[weak self] (errorTag,errorStr) in
            guard let weakSelf = self else { return }
            weakSelf.tableView.mj_header.endRefreshing()
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
}

// MARK: - Table view data source
extension BarcodeCheckVc: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return vm.forms.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cellVM = vm.forms[indexPath.row]
        let cellIdentifier = cellVM.cellId.isEmpty ? String(describing: cellVM.cellClass) : cellVM.cellId
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        if cell == nil {
            let bundle = Bundle.main.path(forResource:cellIdentifier, ofType: "nib")
            if bundle == nil{
                tableView.register(cellVM.cellClass, forCellReuseIdentifier: cellIdentifier)
            }else{
                let cellNib = UINib(nibName:cellIdentifier, bundle: nil)
                tableView.register(cellNib, forCellReuseIdentifier: cellIdentifier)
            }
            cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        }
        
        guard let endCell = cell else {
            fatalError("没有找到标识为：\(cellIdentifier)的Cell")
        }
        cellVM.bind(endCell)
        return endCell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        view.backgroundColor = UIColor.init(hexString: "f8f8f8")
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, estimatedHeightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        let cellVM = vm.forms[indexPath.row]
        return cellVM.frameH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cellVM = vm.forms[indexPath.row]
        cellVM.tapBlock?()
    }
}
