//
//  BarcodeCheckVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/31.
//

import UIKit

class BarcodeCheckVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var codeDict = [String:Any]()
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []

        newForms += makeItemForms()
        forms = newForms
        callback?()
    }
    
    func makeItemForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        // header Cell_BarcodeCheckHeader
        do {
            let code = codeDict.stringValue(forKey: "itemBarcode")
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_BarcodeCheckHeader>.init(data: (code), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (15, 15, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_BarcodeCheckInfoHeader>.init(data: (""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        
        
       //内容
        newForms.append(self.makeTextLineCell("产品编码".languageString(), value: codeDict.stringValue(forKey: "itemCode")))
        newForms.append(self.makeTextLineCell("产品名称".languageString(), value: codeDict.stringValue(forKey: "itemName")))
        newForms.append(self.makeTextLineCell("产品型号".languageString(), value: codeDict.stringValue(forKey: "itemShortName")))
        newForms.append(self.makeTextLineCell("产品二维码".languageString(), value: codeDict.stringValue(forKey: "itemBarcode")))
        newForms.append(self.makeTextLineCell("经销商".languageString(), value: codeDict.stringValue(forKey: "saler")))
        newForms.append(self.makeTextLineCell("下单时间".languageString(), value: codeDict.stringValue(forKey: "saleOrderTime")))
        newForms.append(self.makeTextLineCell("发货时间".languageString(), value: codeDict.stringValue(forKey: "deliverTime")))
        newForms.append(self.makeTextLineCell("安装标识".languageString(), value: codeDict.stringValue(forKey: "installInfo")))
        newForms.append(self.makeTextLineCell("安装网点".languageString(), value: codeDict.stringValue(forKey: "installSite")))
        newForms.append(self.makeTextLineCell("安装师傅".languageString(), value: codeDict.stringValue(forKey: "installEngineer")))
        newForms.append(self.makeTextLineCell("客户姓名".languageString(), value: codeDict.stringValue(forKey: "custInfo")))
        newForms.append(self.makeTextLineCell("客户地址".languageString(), value: codeDict.stringValue(forKey: "custAddress")))
        newForms.append(self.makeTextLineCell("回访时间".languageString(), value: codeDict.stringValue(forKey: "recallTime")))
        newForms.append(self.makeTextLineCell("回访情况".languageString(), value: codeDict.stringValue(forKey: "recallInfo")))
        newForms.append(self.makeTextLineCell("其他说明".languageString(), value: codeDict.stringValue(forKey: "otherInfo")))
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (15, 15, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
       return newForms
    }
    
    
    func makeTextLineCell(_ title:String,value:String) ->TCCellBaseProtocol{
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .showLine(false)
                .title(title)
                .bgColor(UIColor(hexString: "f8f8f8"))
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "999999"))
                .infoColor(UIColor(hexString: "333333"))
                .textAlignment(.left)
            let rowCell = TCFormCellModel<TCTextLineCell>.init(data: (76, value, "",15,15), config: uiConfigModel, id: nil, frameh: 30, didSelect:  {
            })
            return rowCell
        }
    }
}
