//
//  CreatOrderBaseDataVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/29.
//

import UIKit

class CreatOrderBaseDataVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var selCallback:(([String:Any])->())?
    var itemArr = [[String:Any]]()
    var itemKey = "brandName"
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []

        newForms += makeItemForms()
        forms = newForms
        callback?()
    }
    
    func makeItemForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []

        guard itemArr.count > 0  else {
            return []
        }
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (15, 15, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        for (index,item) in itemArr.enumerated() {
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(15).setBgViewTrailing(15).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title("")
                    .titleFont(UIFont.systemFont(ofSize: 15))
                    .titleColor(UIColor(hexString: "666666"))
                    .infoFont(UIFont.boldSystemFont(ofSize: 15))
                    .infoColor(UIColor(hexString: "333333"))
                    .showNext(true)
                    .showLine(index != itemArr.count-1)
                    .textAlignment(.left)
                
                let value = item.stringValue(forKey: itemKey)
                
                let rowCell = TCFormCellModel<TCLabelCell>.init(data: (10, value, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                    guard let weakSelf = self else { return }
                    weakSelf.selCallback?(item)
                })
                newForms.append(rowCell)
            }
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (15, 15, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
       return newForms
    }
}
