//
//  CreatOrderItemVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/29.
//

import UIKit

class CreatOrderItemVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var selectImageCallback:((Int,Int)->())?
    var selectCodeCallback:((String,Int)->())?
    var canEdit = true
    var model = M_CreatOrder()
    
    func makeForms(){
        for (i, item) in model.items.enumerated() {
            var it = item
            it.hasIemi = model.hasIemi
            it.picList = model.resultPicList
            model.items[i] = it
        }
       var newForms:[TCCellBaseProtocol] = []
        newForms += makeInfoForms()
        newForms += makeItemForms()
        
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do {
           
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("服务类型".languageString())
                .titleFont(UIFont.systemFont(ofSize: 15))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.boldSystemFont(ofSize: 15))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(true)
                .showLine(true)
                .textAlignment(.left)
            
            let placeholderText = !canEdit ? "" : "请选择".languageString()
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, model.servicetypename, placeholderText), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                guard let weakSelf = self else { return }
                
                let vc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "CreatOrderBaseDataVc") as! CreatOrderBaseDataVc
                vc.title = "服务类型".languageString()
                vc.getDataUrl = "app/v2/basicInformation/getServiceType"
                vc.vm.itemKey = "serviceTypeName"
                vc.listKey = "serviceTypeList"
                vc.selCallback = { (selItem) in
                    weakSelf.model.servicetypeid = selItem.stringValue(forKey: "serviceTypeId")
                    weakSelf.model.servicetypename = selItem.stringValue(forKey: "serviceTypeName")
                    weakSelf.model.resultPicList = selItem.arrayValue(forKey: "resultPicList").compactMap({M_CreatOrder.ScanImageModel($0)})
                    if selItem.keys.contains("iemi") {
                        weakSelf.model.hasIemi = true
                    }else{
                        weakSelf.model.hasIemi = false
                    }
                    weakSelf.makeForms()
                }
                CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
                
            })
            newForms.append(rowCell)
        }
    
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("品      牌".languageString())
                .titleFont(UIFont.systemFont(ofSize: 15))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.boldSystemFont(ofSize: 15))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(true)
                .showLine(true)
                .textAlignment(.left)
            
            let placeholderText = !canEdit ? "" : "请选择".languageString()
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, model.brandname, placeholderText), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                guard let weakSelf = self else { return }
                
                let vc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "CreatOrderBaseDataVc") as! CreatOrderBaseDataVc
                vc.title = "选择品牌".languageString()
                vc.getDataUrl = "app/v2/basicInformation/getBrand"
                vc.vm.itemKey = "brandName"
                vc.listKey = "brandList"
                vc.selCallback = { (selItem) in
                    weakSelf.model.brandid = selItem.stringValue(forKey: "brandId")
                    weakSelf.model.brandname = selItem.stringValue(forKey: "brandName")
                    weakSelf.makeForms()
                }
                CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setCellColor(UIColor(hexString: "f8f8f8"))
                .bgColor(UIColor(hexString: "F6FDFC"))
            let rowCell = TCFormCellModel<Cell_OrderCreatSwitch>.init(data: ("保修类型".languageString(),model.guaranteeType,["保内".languageString(),"保外".languageString()],[1,2]), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                guard let weakSelf = self else { return }
                if let type = a as? Int {
                    weakSelf.model.guaranteeType = type
                    weakSelf.makeForms()
                }
            }
            newForms.append(rowCell)
        }
        
        return newForms
    }
    
    func makeItemForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        
        guard model.items.count > 0 else {
            return []
        }
        
        for (index,item) in model.items.enumerated() {
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
                newForms.append(rowCell)
            }
                        
            do {
                let title = "产品".languageString()+"[\(index+1)]"
                let flag = index != 0 //可否删除
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_OrderCreatItemHeader>.init(data: (title,flag), config: uiConfigModel, id: nil, frameh: 40) {[weak self] (a) in
                    //删除该项
                    self?.model.items.remove(at: index)
                    self?.makeForms()
                    
                }
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.white)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(2.5)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12,12, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 5)
                newForms.append(rowCell)
            }
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_OrderCreatItemClass>.init(data: (item.bigitemcatname,item.smallitemcatname), config: uiConfigModel, id: nil, frameh: 50) { [weak self] (a) in
                    guard let weakSelf = self else { return }
                    if let typeStr = a as? String {
                        if typeStr == "大类"{
                            let vc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "CreatOrderBaseDataVc") as! CreatOrderBaseDataVc
                            vc.title = "请选择".languageString()+"大类".languageString()
                            vc.getDataUrl = "app/v2/basicInformation/getItemCat"
                            vc.vm.itemKey = "categoryName"
                            vc.subJoinParam = ["brandId":weakSelf.model.brandid]
                            vc.listKey = "itemCatList"
                            vc.selCallback = { (selItem) in
                                var newItem = item
                                
                                newItem.bigitemcatname = selItem.stringValue(forKey: "categoryName")
                                newItem.bigitemcatid = selItem.stringValue(forKey: "itemCatId")
                                
                                if newItem.bigitemcatid != item.bigitemcatid {
                                    //清除小类，机型
                                    newItem.itemid = ""
                                    newItem.itemname = ""
                                    newItem.entId = ""
                                    newItem.smallitemcatid = ""
                                    newItem.smallitemcatname = ""
                                    
                                    //条码数
                                    newItem.hasInCode = false
                                    newItem.hasOutCode = false
                                    newItem.hasBarCode3 = false
                                    
                                    let dict = selItem as NSDictionary
                                    for key in dict.allKeys{
                                          if key as! String == "inCode" {
                                             //有一码
                                              newItem.hasInCode = true
                                          }
                                        if key as! String == "outCode" {
                                           //有二码
                                            newItem.hasOutCode = true
                                        }
                                        if key as! String == "barCode3" {
                                            //有三码
                                            newItem.hasBarCode3 = true
                                        }
                                    }
                                }
                                weakSelf.model.items[index] = newItem
                                
                                weakSelf.makeForms()
                            }
                            CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
                        }
                        else{
                            if item.bigitemcatid == ""{
                                hud_info("请选择".languageString()+"大类".languageString())
                                return}
                            let vc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "CreatOrderBaseDataVc") as! CreatOrderBaseDataVc
                            vc.title = "请选择".languageString()+"小类".languageString()
                            vc.getDataUrl = "app/v2/basicInformation/getItemCat"
                            vc.vm.itemKey = "categoryName"
                            vc.parentId = item.bigitemcatid
                            vc.listKey = "itemCatList"
                            vc.selCallback = { (selItem) in
                                var newItem = item
                                newItem.smallitemcatname = selItem.stringValue(forKey: "categoryName")
                                newItem.smallitemcatid = selItem.stringValue(forKey: "itemCatId")
                                
                                if newItem.smallitemcatid != item.smallitemcatid {
                                    //清除机型
                                    newItem.itemid = ""
                                    newItem.itemname = ""
                                    newItem.entId = ""
                                    
                                    //条码数
                                    newItem.hasInCode = false
                                    newItem.hasOutCode = false
                                    newItem.hasBarCode3 = false
                                    
                                    let dict = selItem as NSDictionary
                                    for key in dict.allKeys{
                                          if key as! String == "inCode" {
                                             //有一码
                                              newItem.hasInCode = true
                                          }
                                        if key as! String == "outCode" {
                                           //有二码
                                            newItem.hasOutCode = true
                                        }
                                        if key as! String == "barCode3" {
                                            //有三码
                                            newItem.hasBarCode3 = true
                                        }
                                    }
                                }
                                weakSelf.model.items[index] = newItem
                                weakSelf.makeForms()
                            }
                            CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
                        }
                    }
                    
                }
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_OrderCreatItemCodeHeader>.init(data: (model.usertype), config: uiConfigModel, id: nil, frameh: 40) { a in
                    //识别条码
                    self.selectCodeCallback?(item.inbarcode,index)
                    
                }
                newForms.append(rowCell)
            }
            
            //code 1
            if item.hasInCode == true{
                do {
                    let cfModel = TCFormCellConfigModel(titleStr: "条码1".languageString())
                        .canEdit(canEdit)
                    let rowCell = TCFormCellModel<Cell_FinishItemCode>.init(data: (item.inbarcode, "请扫描或输入条码1".languageString()), config: cfModel, id: nil, frameh: 52, callBack: { [weak self] callValue in
                        if let cValue = callValue as? (UIControl.Event, String) {
                            if cValue.0 == .editingChanged  {
                                var newItem = item
                                newItem.inbarcode = cValue.1
                                self?.model.items[index] = newItem
                            }else if cValue.0 == .editingDidEnd  {
                                self?.makeForms()
                            }
                        }
                        if let actionStr = callValue as? String {
                            //扫码
                            guard self?.canEdit == true else {
                                return
                            }
                            let qrVC = QRViewController()
                            qrVC.configResultCall { code, errorStr in
                                if errorStr != "" {
                                    CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~".languageString())
                                    return
                                }
                                var newItem = item
                                newItem.inbarcode = code ?? ""
                                self?.model.items[index] = newItem
                                self?.makeForms()
                                
                                //识别条码
                                self?.selectCodeCallback?(newItem.inbarcode,index)
                            }
                            let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
                            qrNavigationC.modalPresentationStyle = .overFullScreen
                            qrNavigationC.modalTransitionStyle = .crossDissolve
                            CD.visibleVC?.present(qrNavigationC, animated: true, completion: nil)
                        }
                    }, didSelect: nil)
                    newForms.append(rowCell)
                }
            }
            
            //code 2
            if item.hasOutCode == true{
                do {
                    let cfModel = TCFormCellConfigModel(titleStr: "条码2".languageString())
                        .canEdit(canEdit)
                    let rowCell = TCFormCellModel<Cell_FinishItemCode>.init(data: (item.outbarcode, "请扫描或输入条码2".languageString()), config: cfModel, id: nil, frameh: 52, callBack: { [weak self] callValue in
                        if let cValue = callValue as? (UIControl.Event, String) {
                            if cValue.0 == .editingChanged  {
                                var newItem = item
                                newItem.outbarcode = cValue.1
                                self?.model.items[index] = newItem
                            }else if cValue.0 == .editingDidEnd  {
                                self?.makeForms()
                            }
                        }
                        if let actionStr = callValue as? String {
                            //扫码
                            guard self?.canEdit == true else {
                                return
                            }
                            let qrVC = QRViewController()
                            qrVC.configResultCall { code, errorStr in
                                if errorStr != "" {
                                    CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~".languageString())
                                    return
                                }
                                var newItem = item
                                newItem.outbarcode = code ?? ""
                                self?.model.items[index] = newItem
                                self?.makeForms()
                            }
                            let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
                            qrNavigationC.modalPresentationStyle = .overFullScreen
                            qrNavigationC.modalTransitionStyle = .crossDissolve
                            CD.visibleVC?.present(qrNavigationC, animated: true, completion: nil)
                            
                        }
                    }, didSelect: nil)
                    newForms.append(rowCell)
                }
            }
            
            //code 3
            if item.hasBarCode3 == true{
                do {
                    let cfModel = TCFormCellConfigModel(titleStr: "条码3".languageString())
                        .canEdit(canEdit)
                    let rowCell = TCFormCellModel<Cell_FinishItemCode>.init(data: (item.barCode3, "请扫描或输入条码3".languageString()), config: cfModel, id: nil, frameh: 52, callBack: { [weak self] callValue in
                        if let cValue = callValue as? (UIControl.Event, String) {
                            if cValue.0 == .editingChanged  {
                                var newItem = item
                                newItem.barCode3 = cValue.1
                                self?.model.items[index] = newItem
                            }else if cValue.0 == .editingDidEnd  {
                                self?.makeForms()
                            }
                        }
                        if let actionStr = callValue as? String {
                            //扫码
                            guard self?.canEdit == true else {
                                return
                            }
                            let qrVC = QRViewController()
                            qrVC.configResultCall { code, errorStr in
                                if errorStr != "" {
                                    CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~".languageString())
                                    return
                                }
                                var newItem = item
                                newItem.barCode3 = code ?? ""
                                self?.model.items[index] = newItem
                                self?.makeForms()
                            }
                            let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
                            qrNavigationC.modalPresentationStyle = .overFullScreen
                            qrNavigationC.modalTransitionStyle = .crossDissolve
                            CD.visibleVC?.present(qrNavigationC, animated: true, completion: nil)
                            
                        }
                    }, didSelect: nil)
                    newForms.append(rowCell)
                }
            }
            
            //IEMI
            if model.hasIemi {
                do {
                    let cfModel = TCFormCellConfigModel(titleStr: "IEMI")
                        .canEdit(canEdit)
                    let rowCell = TCFormCellModel<Cell_FinishItemCode>.init(data: (item.iemi, "请扫码或输入IEMI物联码~".languageString()), config: cfModel, id: nil, frameh: 52, callBack: { [weak self] callValue in
                        if let cValue = callValue as? (UIControl.Event, String) {
                            if cValue.0 == .editingChanged  {
                                self?.model.items[index].iemi = cValue.1
                            }else if cValue.0 == .editingDidEnd  {
                                self?.makeForms()
                            }
                        }
                        if let actionStr = callValue as? String {
                            //扫码
                            guard self?.canEdit == true else {
                                return
                            }
                            let qrVC = QRViewController()
                            qrVC.configResultCall { code, errorStr in
                                if errorStr != "" {
                                    CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~".languageString())
                                    return
                                }
                                self?.model.items[index].iemi = code!
                                self?.makeForms()
                            }
                            let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
                            qrNavigationC.modalPresentationStyle = .overFullScreen
                            qrNavigationC.modalTransitionStyle = .crossDissolve
                            CD.visibleVC?.present(qrNavigationC, animated: true, completion: nil)
                            
                        }
                    }, didSelect: nil)
                    newForms.append(rowCell)
                }
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_OrderCreatItemSelecte>.init(data: (item.itemname), config: uiConfigModel, id: nil, frameh: 50) { [weak self] (a) in
                    guard let weakSelf = self else { return }
                    if item.bigitemcatid == ""{
                        hud_info("请选择".languageString()+"大类".languageString())
                        return}
                    let vc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "CreatOrderBaseDataVc") as! CreatOrderBaseDataVc
                    vc.title = "选择型号".languageString()
                    vc.isShowHeader = true
                    vc.loadMore = true
                    vc.getDataUrl = "app/v2/basicInformation/getItem"
                    vc.vm.itemKey = "itemName"
                    vc.parentId = item.bigitemcatid
                    var brandId = item.brandId
                    if brandId == ""{brandId = weakSelf.model.brandid }
                    vc.subJoinParam = ["bigCategoryId":item.bigitemcatid,"brandId":brandId]
                    if item.smallitemcatid != ""{
                        vc.subJoinParam = ["bigCategoryId":item.bigitemcatid,"smallCategoryId":item.smallitemcatid,"brandId":brandId]
                    }
                    vc.listKey = "itemList"
                    vc.selCallback = { (selItem) in
                        var newItem = item
                        newItem.itemid = selItem.stringValue(forKey: "id")
                        newItem.itemname = selItem.stringValue(forKey: "itemName")
                        newItem.itemcode = selItem.stringValue(forKey: "itemCode")
                        newItem.entId = selItem.stringValue(forKey: "entId")
                        
                        newItem.brandId = selItem.stringValue(forKey: "brandId")
                        
                        weakSelf.model.items[index] = newItem
                        
                        //品牌更新
                        if index == 0{
                            weakSelf.model.brandid = selItem.stringValue(forKey: "brandId")
                            weakSelf.model.brandname = selItem.stringValue(forKey: "brandName")
                        }
                        weakSelf.makeForms()
                    }
                    CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
                    
                }
                newForms.append(rowCell)
            }
            
     /*
            //图片 -- 没有图片了
            var images = [M_CreatOrder.ScanImageModel]()
            images.append(M_CreatOrder.ScanImageModel())
            images.append(M_CreatOrder.ScanImageModel())
            images.append(M_CreatOrder.ScanImageModel())
            images.append(M_CreatOrder.ScanImageModel())
            
            //图片Cell_OrderFinishImages
            do {
                let cfModel = TCFormCellConfigModel(titleStr: "图片")
                
                let rowCell = TCFormCellModel<Cell_OrderFinishImages>.init(data: (images), config: cfModel, id: nil, frameh: 120, callBack: { [weak self] callValue in
                    if let actionIndex = callValue as? Int {
                        debugPrint("点击了第n个")
                        debugPrint(actionIndex)
                        self?.selectImageCallback?(index,actionIndex)
                    }
                    
                    if let imageUrl = callValue as? String {
                        //查看示例图
                        var picList = [String]()
                        picList.append(imageUrl)
                        let photos = picList.compactMap({ (item) -> GKPhoto in
                            let photo = GKPhoto()
                            guard let imageUrl = URL(string: item) else {
                                return photo
                            }
                            photo.url = imageUrl
                            return photo
                        })
                        
                        let index = 0
                        
                        let browser = GKPhotoBrowser(photos: photos, currentIndex: index)
                        browser.showStyle = .none
                        browser.modalPresentationStyle = .overFullScreen
                        browser.show(fromVC: CD.visibleVC!)
                    }
                }, didSelect: nil)
                newForms.append(rowCell)
            }
      
      
      */
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.white)
                    .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.white)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
        }
      
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.white)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        if !model.resultPicList.isEmpty {
            //图片Cell_OrderFinishImages
            do {
                let cfModel = TCFormCellConfigModel(titleStr: "现场图片".languageString()).canEdit(self.canEdit)
                var height:CGFloat = 0
                let count = model.resultPicList.count
                if count > 0 {
                    //需要几行 n%2 = 0 n/2行   n%2 = 1 n/2+1
                    var n = 0
                    if count % 2 == 0 {
                        n = count/4
                    }
                    if count % 4 == 2 {
                        n = (count/4)+1
                    }
                    if count % 2 == 1 {
                        n = (count/4)+1
                    }
                    height = CGFloat(n) * 125
                }
                
                let rowCell = TCFormCellModel<Cell_OrderCreatFinishImages>.init(data: (model.resultPicList), config: cfModel, id: nil, frameh: height, callBack: { [weak self] callValue in
                    
                    guard let weakSelf = self else { return }
                    
                    if let actionArr = callValue as? (String,Int) {
                        guard weakSelf.canEdit else {
                            return
                        }
                        debugPrint("点击了第n个")
                       let actionFlag = actionArr.0
                       let actionIndex = actionArr.1
                        
                        if actionFlag == "add"{
                            weakSelf.selectImageCallback?(0,actionIndex)
                        }
                        
                        if actionFlag == "delete"{
                            weakSelf.model.resultPicList[actionIndex].pic = ""
                            weakSelf.makeForms()
                        }
                    
                    }
                    
                    if let imageUrl = callValue as? String {
                        //查看大图
                        let picUrl = kGetServerPicUrl(imageUrl)
                        var picList = [String]()
                        picList.append(picUrl)
                        let photos = picList.compactMap({ (item) -> GKPhoto in
                            let photo = GKPhoto()
                            guard let imageUrl = URL(string: item) else {
                                return photo
                            }
                            photo.url = imageUrl
                            return photo
                        })
                        
                        let index = 0
                        
                        let browser = GKPhotoBrowser(photos: photos, currentIndex: index)
                        browser.showStyle = .none
                        browser.modalPresentationStyle = .overFullScreen
                        browser.show(fromVC: CD.visibleVC!)
                    }
                }, didSelect: nil)
                newForms.append(rowCell)
            }
      
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.white)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 20)
            newForms.append(rowCell)
        }
        
        /********0311暂时去掉
        //新增
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_OrderCreatAdd>.init(data: (""), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                guard let weakSelf = self else { return }
                if let type = a as? Int {
                   //xinz
                    debugPrint("新增~")
                    
                    var newItem = M_CreatOrder.M_Item()
                    newItem.brandId = weakSelf.model.brandid
                    weakSelf.model.items.append(newItem)
                    weakSelf.makeForms()
                }
                
            }
            newForms.append(rowCell)
        }
         */
        
        return newForms
    }
}
