//
//  CreatOrderUserVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/29.
//

import UIKit

class CreatOrderUserVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var canEdit = true
    var model = M_CreatOrder()
    
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []
        newForms += makeUserInfoForms()
      
        forms = newForms
        callback?()
    }
    
    func makeUserInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_OrderCreatSelectUserType>.init(data: (model.usertype), config: uiConfigModel, id: nil, frameh: 60) { a in
                if let type = a as? Int {
                    self.model.usertype = type.stringValue
                    self.makeForms()
                }
               
            }
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "用户姓名".languageString()).showTip(false).setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .infoFont(UIFont.boldSystemFont(ofSize: 15))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
                .showLine(true)
                .showTip(false)
                .canEdit(canEdit)
            
            let placeholderText = !canEdit ? "" : "请输入".languageString()
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, model.username, placeholderText, nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.model.username = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "用户手机".languageString()).showTip(false).setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .infoFont(UIFont.boldSystemFont(ofSize: 15))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
                .showTip(false)
                .showLine(true)
                .canEdit(canEdit)
            
            let placeholderText = !canEdit ? "" : "请输入".languageString()
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, model.usermobile, placeholderText, nil, .phonePad), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.model.usermobile = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        let mobile = cValue.1
                        if !mobile.isValidatePhoneNumber(){
                            CD.visibleVC?.promptInformation("请正确输入11位手机号~".languageString())
                        }
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        do {
           
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("省市区镇".languageString())
                .titleFont(UIFont.systemFont(ofSize: 15))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.boldSystemFont(ofSize: 15))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(true)
                .showTip(false)
                .showLine(true)
                .textAlignment(.left)
            
            let placeholderText = !canEdit ? "" : "请选择".languageString()
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, model.areaname, placeholderText), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                guard let weakSelf = self else { return }
                
                let vc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "VC_SelectArea") as! VC_SelectArea
                vc.modalTransitionStyle = .crossDissolve
                vc.modalPresentationStyle = .custom
                vc.style = .省市区街道
                vc.pickerEndCall = { (areaId,areaName) in
                    weakSelf.model.areaid = areaId
                    weakSelf.model.areaname = areaName
                    weakSelf.makeForms()
                }
                CD.visibleVC?.present(vc, animated: true, completion: nil)
            })
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "详细地址".languageString()).showTip(false).setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .infoFont(UIFont.boldSystemFont(ofSize: 15))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
                .showLine(true)
                .showTip(false)
                .canEdit(canEdit)
            
            let placeholderText = !canEdit ? "" : "请输入".languageString()
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, model.useraddress, placeholderText, nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.model.useraddress = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("购买渠道".languageString())
                .titleFont(UIFont.systemFont(ofSize: 15))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.boldSystemFont(ofSize: 15))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(true)
                .showTip(false)
                .showLine(true)
                .textAlignment(.left)
            
            let placeholderText = !canEdit ? "" : "请选择".languageString()
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, model.buyChannelName, placeholderText), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                guard let weakSelf = self else { return }
                let vc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "CreatOrderBaseDataVc") as! CreatOrderBaseDataVc
                vc.title = "购买渠道".languageString()
                vc.getDataUrl = "app/v2/basicInformation/getBuyChannel"
                vc.vm.itemKey = "buyChannelName"
                vc.listKey = "buyChannelList"
                vc.selCallback = { (selItem) in
                    weakSelf.model.buyChannelId = selItem.stringValue(forKey: "buyChannelId")
                    weakSelf.model.buyChannelName = selItem.stringValue(forKey: "buyChannelName")
                    weakSelf.makeForms()
                }
                CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
                
            })
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "购买地点".languageString()).showTip(false).setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .infoFont(UIFont.boldSystemFont(ofSize: 15))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
                .showLine(true)
                .showTip(false)
                .canEdit(canEdit)
            
            let placeholderText = !canEdit ? "" : "请输入".languageString()
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, model.buyshopname, placeholderText, nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.model.buyshopname = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("购买时间".languageString())
                .titleFont(UIFont.systemFont(ofSize: 15))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.boldSystemFont(ofSize: 15))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(true)
                .showTip(false)
                .showLine(true)
                .textAlignment(.left)
            
            let placeholderText = !canEdit ? "" : "请选择".languageString()
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, model.buydate, placeholderText), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
            
                TSDatePickerVC.showDatePicker(titleStr: "请选择购买日期".languageString(), maxDate: Date(), minDate: nil) { [weak self] (selDate) in
                    guard let weakSelf = self else { return }
                    let format = DateFormatter()
                    format.dateFormat = "yyyy-MM-dd"
                    weakSelf.model.buydate = format.string(from: selDate)
                    weakSelf.makeForms()
                }.show(CD.visibleVC!)
            })
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "购买发票".languageString()).showTip(false).setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .infoFont(UIFont.boldSystemFont(ofSize: 15))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
                .showLine(true)
                .canEdit(canEdit)
            
            let placeholderText = !canEdit ? "" : "请输入".languageString()
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, model.invoiceno, placeholderText, nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.model.invoiceno = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "远程公里".languageString()).showTip(false).setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .infoFont(UIFont.boldSystemFont(ofSize: 15))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
                .showLine(true)
                .canEdit(canEdit)
            
            let placeholderText = !canEdit ? "" : "请输入".languageString()
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, model.longdis, placeholderText, nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.model.longdis = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "备      注".languageString()).showTip(false).setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .infoFont(UIFont.boldSystemFont(ofSize: 15))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
                .showLine(true)
                .canEdit(canEdit)
            
            let placeholderText = !canEdit ? "" : "请输入".languageString()
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, model.remark, placeholderText, nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.model.remark = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        return newForms
    }
}
