//
//  M_FinishFeesCategory.swift
//  VattiCSS
//
//  Created by WZR on 2024/1/3.
//

import Foundation

class M_FinishFeesCategory: NSObject {
    var bigTypeId = ""        // 费用大类ID);
    var bigTypeName = ""        // 费用大类名称);
    var smallTypeList:[SmallType] = []        // 大类下的小类列表;
    var select = false

    init(_ data:[String:Any] = [:]) {
        bigTypeId = data.stringValue(forKey: "bigTypeId")
        bigTypeName = data.stringValue(forKey: "bigTypeName")
        smallTypeList = data.arrayValue(forKey: "smallTypeList").compactMap({SmallType($0)})
    }
         
    func jsonValue() -> [String:Any] {
        var par:[String:Any] = [:]
        par["bigTypeId"] = bigTypeId
        par["bigTypeName"] = bigTypeName
        par["smallTypeList"] = smallTypeList.compactMap({$0.jsonValue()})
        return par
    }
       
    struct SmallType {
        var smallTypeId = ""    // 费用小类ID
        var smallTypeName = ""      //
        var isShow = false
        var feesList:[FeeItem] = []
        
        init(_ data:[String:Any] = [:]) {
            smallTypeId = data.stringValue(forKey: "smallTypeId")
            smallTypeName = data.stringValue(forKey: "smallTypeName")
        }
        
        func jsonValue() -> [String:Any] {
            var par:[String:Any] = [:]
            par["smallTypeId"] = smallTypeId
            par["smallTypeName"] = smallTypeName
            par["feesList"] = feesList.compactMap({$0.jsonValue()})
            return par
        }
    }
    
    struct FeeItem {
        var subjectId = ""
        var subjectName = ""
        var spec = ""
        
        var qty = 0
        var price = ""
        var unit = ""
        
        init(json:[String:Any] = [:]) {
            subjectId = json.stringValue(forKey: "subjectId")
            subjectName = json.stringValue(forKey: "subjectName")
            qty = json.intValue(forKey: "qty")
            let p = json.double("price")
            price = p?.stringValue ?? "0.00"
            unit = json.stringValue(forKey: "unit")
            spec = json.stringValue(forKey: "spec")
        }
        
        //make json
        func jsonValue() -> [String:Any] {
            var param:[String:Any] = [:]
            param["subjectId"] = subjectId
            param["subjectName"] = subjectName
            param["qty"] = qty
            param["price"] = price
            param["unit"] = unit
            param["spec"] = spec
            param["amount"] = price
            return param
        }
    }
                                             
}
