//
//  M_FinishOrder.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/4.
//

import UIKit

struct M_FinishOrder {

    var username = ""
    var usermobile = ""
    var useraddress = ""
    
    var finishButton = ""
    var finishNote = ""
    var finishStatus = 1 //选定的完工状态值:1正常完工;2无法完工;3需再次服务
    
    //是否可上传视频 0否1是
    var companyUploadFinishVedio = ""
    //是否允许使用相册图片 0否1是
    var companyAppUploadPicType = ""
    
    var guaranteeType = 0 //guaranteeType", 保修类型：1保内、2保外、3未知
    var oldGuaranteeType = 0 //如果后台返回的保修类型guaranteeType=1时,允许切换成保外;
    
    var orderId = ""
    var orderStat = ""
    var outTransIn = -1  //0否1是
    var hasOutTransIn = false
    
    var serviceTypeId = ""
    var serviceTypeName = ""
    var serviceTypeBusinessType = ""
    //新增字段
    var buyChannelId = ""
    var buyChannelName = ""
    var hasChannelName = false
    
    var virtuallyUserMobile = ""
    var hasVirtuallyUserMobile = false
    
    var hasPolicy = false
    var isPolicy = -1 //是否政策性  0否1是
    
    var hasSafeEnvironmen = false
    var isSafeEnvironment = -1 //安装环境是否符合:0否1是
    
    var showFields = [M_ShowField]()
    var items = [M_Item]()
    //第一个产品
    var itemid = ""
    var itemCategoryId = ""
    var code1 = ""
    
    var hasParts = false
    var partsList = [M_Part]()
    var faultList = [M_Fault]()
    
    //费用
    var specailAmountPic1 = ""
    var specailAmountPic2 = ""
    var specailAmountPic3 = ""
    var specailAmountRemark = ""
    
    var userPayAmount = ""
    var userPayDiscount = ""
    
    var userPayPic1 = ""
    var userPayPic2 = ""
    var userPayPic3 = ""
    var userPayRemark = ""
    
    //费用验证码
    var userMobile = ""
    var userFeeVerification = "" //用户收费验证码确认:0否1是
    var userFeeVerificationValue = "" //用户收费验证码);
    
    var ontimelocation = ""
    
    var companymanyfault = 0
    
    //费用项
    var siteAmount = ""
    var rewardAmount = ""
    var longDistance = ""
    var longDistanceAmount = ""
    var rewardReason = ""
    var specailAmount = ""
    var siteFinalAmount = ""
    
    var showFeeList = [M_FeeLine]()
    var specailFeeList = [M_FeeItem]()
    var userPayList = [M_FeeItem]()

    init(json:[String:Any]) {
        
         serviceTypeId = json.stringValue(forKey: "serviceTypeId")
         serviceTypeName = json.stringValue(forKey: "serviceTypeName")
         serviceTypeBusinessType = json.stringValue(forKey: "serviceTypeBusinessType")
        
         buyChannelName = json.stringValue(forKey: "buyChannelName")
         buyChannelId = json.stringValue(forKey: "buyChannelId")
     
         companyAppUploadPicType = json.stringValue(forKey: "companyAppUploadPicType")
         companyUploadFinishVedio = json.stringValue(forKey: "companyUploadFinishVedio")
        
         finishButton = json.stringValue(forKey: "finishButton")
         finishNote = json.stringValue(forKey: "finishNote")
        
          let status = json.intValue(forKey: "finishStatus")
          if status > 0 {
            finishStatus = status
          }
         
        if json.stringValue(forKey: "outTransIn") != ""{
            outTransIn = json.intForKey("outTransIn") //0否1是
        }
         guaranteeType = json.intForKey("guaranteeType")
        
         oldGuaranteeType = json.intForKey("guaranteeType")
         if serviceTypeBusinessType == "1"{
            //默认保内
            guaranteeType = 1
         }
        
        if json.stringValue(forKey: "isPolicy") != ""{
            isPolicy = json.intForKey("isPolicy") //0否1是
        }
        if json.stringValue(forKey: "isSafeEnvironment") != ""{
            isSafeEnvironment = json.intForKey("isSafeEnvironment") //0否1是
        }
        
        virtuallyUserMobile = json.stringValue(forKey: "virtuallyUserMobile")
        
         orderId = json.stringValue(forKey: "orderId")
         orderStat = json.stringValue(forKey: "orderStat")
    
        userMobile = json.stringValue(forKey: "userMobile")
        userFeeVerification = json.stringValue(forKey: "userFeeVerification")
        
        specailAmountPic1 = json.stringValue(forKey: "specailAmountPic1")
        specailAmountPic2 = json.stringValue(forKey: "specailAmountPic2")
        specailAmountPic3 = json.stringValue(forKey: "specailAmountPic3")
        specailAmountRemark = json.stringValue(forKey: "specailAmountRemark")
        userPayAmount = json.stringValue(forKey: "userPayAmount")
        userPayDiscount = json.stringValue(forKey: "userPayDiscount")
        userPayPic1 = json.stringValue(forKey: "userPayPic1")
        userPayPic2 = json.stringValue(forKey: "userPayPic2")
        userPayPic3 = json.stringValue(forKey: "userPayPic3")
        userPayRemark = json.stringValue(forKey: "userPayRemark")
        
        siteAmount = json.stringValue(forKey: "siteAmount")
        rewardAmount = json.stringValue(forKey: "rewardAmount")
        longDistance = json.stringValue(forKey: "longDistance")
        longDistanceAmount = json.stringValue(forKey: "longDistanceAmount")
        rewardReason = json.stringValue(forKey: "rewardReason")
        specailAmount = json.stringValue(forKey: "specailAmount")
        siteFinalAmount = json.stringValue(forKey: "siteFinalAmount")
        
        if let itemDatas = json["itemResultList"] as? [[String:Any]] {
            items = itemDatas.compactMap({ data in
                M_Item(json: data)
            })
            
            if items.count > 0 {
                itemid = items[0].itemid
                //后台id为空的情况可能返回0
                if items[0].bigitemcatid != "" && items[0].bigitemcatid != "0"{
                    itemCategoryId = items[0].bigitemcatid
                }
                if items[0].smallitemcatid != "" && items[0].smallitemcatid != "0"{
                    itemCategoryId = items[0].smallitemcatid
                }
                
                if items[0].inbarcode != ""{
                    code1 = items[0].inbarcode
                }
                
                
            }
        }
        
        if let partDatas = json["partsList"] as? [[String:Any]] {
            partsList = partDatas.compactMap({ data in
                M_Part(json: data)
            })
        }
        
        if let faultDatas = json["faultList"] as? [[String:Any]] {
            faultList = faultDatas.compactMap({ data in
                M_Fault(json: data)
            })
        }
        
        if let feeList = json["specailFeeList"] as? [[String:Any]] {
            specailFeeList = feeList.compactMap({ data in
                M_FeeItem(json: data)
            })
        }
        
        if let feeList = json["userPayList"] as? [[String:Any]] {
            userPayList = feeList.compactMap({ data in
                M_FeeItem(json: data)
            })
        }
        
        if let feeList = json["showFeeList"] as? [[String:Any]] {
            showFeeList = feeList.compactMap({ data in
                M_FeeLine(json: data)
            })
        }
        
//        if let fieldList = json["showFieldList"] as? [[String:Any]] {
//            showFields = fieldList.compactMap({ data in
//                M_ShowField(json: data)
//            })
//        }
        
        let neworderDetial = json as NSDictionary
        for key in neworderDetial.allKeys{
              if key as! String == "faultList" {
                 //有故障树
                  self.companymanyfault = 1
              }
            
            if key as! String == "partsList" {
               //有配件
                self.hasParts = true
            }
            
            if key as! String == "outTransIn" {
               //有保外转保内
                self.hasOutTransIn = true
            }
            
            if key as! String == "buyChannelName" {
               //有渠道
                self.hasChannelName = true
            }
            
            if key as! String == "isPolicy" {
               //有政策
                self.hasPolicy = true
            }
            
            if key as! String == "isSafeEnvironment" {
               //有环境
                self.hasSafeEnvironmen = true
            }
            
            if key as! String == "virtuallyUserMobile" {
               //有用户手机
                self.hasVirtuallyUserMobile = true
            }
            
            
          }
        
        if faultList.count == 0 {
            //初始化 一个故障
            if companymanyfault == 1{
                faultList.append(M_Fault(json: [:]))
            }
        }
    }
    
    // check
    func checkValue() -> String {
        /*
        for item in faultList {
            if item.serviceTypeId == "" {
                return "请选择故障现象~"
            }
            if item.sysmtomId == "" {
                return "请选择故障原因~"
            }
            if item.method_id == "" {
                return "请选择维修措施~"
            }
        }
         */
        
        if self.finishStatus == 0 {
            return "请选择".languageString()+"完工状态".languageString()
        }
        
        //如果选择的是无法完工或需再次上门时,则可以直接提交页面上填好的数据
        if self.finishStatus != 1{
            return ""
        }
        
        if self.guaranteeType == 0 {
            return "请选择".languageString()+"保修类型".languageString()
        }
        
        for item in items {
            if item.hasInCode == true{
                //看条码 保内强制
                if self.guaranteeType == 1{
                    if item.inbarcode == ""{
                        return "请扫码或输入条码~".languageString()
                    }
                    
                    if item.hasOutCode{
                        if item.outbarcode == ""{
                            return "请扫码或输入条码~".languageString()
                        }
                    }
                    
                    if item.hasBarCode3{
                        if item.barCode3 == ""{
                            return "请扫码或输入条码~".languageString()
                        }
                    }
                }
                
            }
            
            if item.hasIemi && item.iemi.isEmpty {
                return "请扫码或输入IEMI物联码~".languageString()
            }
            
            //校验购买时间
            if item.hasBuyDate{
                if item.buyDate == ""{
                    return "请选择".languageString()+"整机产品购买时间".languageString()
                }
            }
            
            for picitem in item.resultPicList {
                if picitem.ismust == "1"{
                    if picitem.pic == "" {
                        return "请上传图片".languageString()+"[\(picitem.picnametemp)]"
                    }
                }
            }
        }
        
        
        //向用户收费验证码核验
        /*
         1.提交完工时增加检查：如果验证码字段有显示但是为空时,提交时进行提示:”收取用户费用时请向用户获取费用验证码”;
         */
        if self.orderStat.intValue() <= 20 && self.userFeeVerification == "2"{
            if userFeeVerificationValue == ""{
                return "请向用户获取费用验证码".languageString()
            }
        }
        
        return ""
    }
    
    //make json
    func jsonValue() -> [String:Any] {
        var param:[String:Any] = [:]
        param["userName"] = username
        param["userMobile"] = usermobile
        param["userAddress"] = useraddress
        
        param["serviceTypeId"] = serviceTypeId
        param["serviceTypeName"] = serviceTypeName
        param["serviceTypeBusinessType"] = serviceTypeBusinessType
        
        param["finishNote"] = finishNote
        param["finishStatus"] = finishStatus
        
        param["guaranteeType"] = guaranteeType
        
        if MapsTool.shareInstance().ontimelocation != ""{
            param["onTimeLocation"] = MapsTool.shareInstance().ontimelocation
        }
        
        param["orderId"] = orderId
        
        param["orderStat"] = orderStat
        
        param["outTransIn"] = outTransIn
      
        param["isPolicy"] = isPolicy
        param["isSafeEnvironment"] = isSafeEnvironment
        param["buyChannelId"] = buyChannelId
        param["buyChannelName"] = buyChannelName
    
        param["virtuallyUserMobile"] = virtuallyUserMobile
        param["userFeeVerificationValue"] = userFeeVerificationValue
        
        param["specailAmountPic1"] = specailAmountPic1
        param["specailAmountPic2"] = specailAmountPic2
        
        param["specailAmountPic3"] = specailAmountPic3
        param["specailAmountRemark"] = specailAmountRemark
        
        param["userPayAmount"] = userPayAmount
        param["userPayDiscount"] = userPayDiscount
        
        param["userPayPic1"] = userPayPic1
        param["userPayPic2"] = userPayPic2
        param["userPayPic3"] = userPayPic3
        param["userPayRemark"] = userPayRemark
        
        param["itemResultList"] = items.compactMap({ (item) -> [String:Any] in
            return item.jsonValue()
        })
        
        if partsList.count != 0{
            param["partsList"] = partsList.compactMap({ (item) -> [String:Any] in
                return item.jsonValue()
            })
        }
        
//        if showFields.count != 0{
//            param["showFieldList"] = showFields.compactMap({ (item) -> [String:Any] in
//                return item.jsonValue()
//            })
//        }
        
        if faultList.count != 0 {
//            param["faultList"] = faultList.compactMap({ (item) -> [String:Any] in
//                return item.jsonValue()
//            })
            
            var faults = [[String:Any]]()
            
            for item in faultList {
                if item.serviceTypeId != "" {
                    faults.append(item.jsonValue())
                }
            }
            
            if faults.count != 0{
                param["faultList"] = faults
            }
        }
      
        param["specailFeeList"] = specailFeeList.compactMap({ (item) -> [String:Any] in
            return item.jsonValue()
        })
        param["userPayList"] = userPayList.compactMap({ (item) -> [String:Any] in
            return item.jsonValue()
        })
        param["showFeeList"] = showFeeList.compactMap({ (item) -> [String:Any] in
            return item.jsonValue()
        })
        return param
    }
    
    //make json
    func makeCachJsonValue() -> [String:Any] {
        var param:[String:Any] = [:]
        param["userName"] = username
        param["userMobile"] = usermobile
        param["userAddress"] = useraddress
        
        param["serviceTypeId"] = serviceTypeId
        param["serviceTypeName"] = serviceTypeName
        param["serviceTypeBusinessType"] = serviceTypeBusinessType
        
        param["isPolicy"] = isPolicy
        param["isSafeEnvironment"] = isSafeEnvironment
        param["buyChannelId"] = buyChannelId
        param["buyChannelName"] = buyChannelName
        param["virtuallyUserMobile"] = virtuallyUserMobile
        
        param["finishNote"] = finishNote
        param["finishStatus"] = finishStatus
        
        param["guaranteeType"] = guaranteeType
    
        param["orderId"] = orderId
        
        param["orderStat"] = orderStat
        
        param["outTransIn"] = outTransIn

        param["specailAmountPic1"] = specailAmountPic1
        param["specailAmountPic2"] = specailAmountPic2
        
        param["specailAmountPic3"] = specailAmountPic3
        param["specailAmountRemark"] = specailAmountRemark
        
        param["userPayAmount"] = userPayAmount
        param["userPayDiscount"] = userPayDiscount
        
        param["userPayPic1"] = userPayPic1
        param["userPayPic2"] = userPayPic2
        param["userPayPic3"] = userPayPic3
        param["userPayRemark"] = userPayRemark
        
        param["itemResultList"] = items.compactMap({ (item) -> [String:Any] in
            return item.jsonValue()
        })
        
        if partsList.count != 0{
            param["partsList"] = partsList.compactMap({ (item) -> [String:Any] in
                return item.jsonValue()
            })
        }
        
        if faultList.count != 0 {
            param["faultList"] = faultList.compactMap({ (item) -> [String:Any] in
                return item.jsonValue()
            })
        }
      
        param["specailFeeList"] = specailFeeList.compactMap({ (item) -> [String:Any] in
            return item.jsonValue()
        })
        param["userPayList"] = userPayList.compactMap({ (item) -> [String:Any] in
            return item.jsonValue()
        })
        param["showFeeList"] = showFeeList.compactMap({ (item) -> [String:Any] in
            return item.jsonValue()
        })
        return param
    }
    
    struct M_Item {

        var qty = ""
        
        var orderLineId = ""
        var resultLineId = ""
        var itemid = ""
        var itemname = ""
        var itemcode = ""
        
        var entId = "0"
        var bigitemcatname = ""
        var bigitemcatid = ""
        
        var smallitemcatname = ""
        var smallitemcatid = ""
        
        var inbarcode = ""
        var outbarcode = ""
        var barCode3 = ""
        
        var hasInCode = false
        var hasOutCode = false
        var hasBarCode3 = false
        
        var hasGuaranteeType = false
        var guaranteeType = ""
        
        var itemEndDate = ""
        var hasItemEndDate = false
        
        var partsEndDate = ""
        var hasPartsEndDate = false
        
        var installDate = ""
        var hasInstallDate = false
        
        var buyDate = ""
        var hasBuyDate = false
        
        var iemi = ""
        var hasIemi = false
        
        ///图片
       var resultPicList = [ScanImageModel]()
        
        init(json:[String:Any]) {
            orderLineId = json.stringValue(forKey: "orderLineId")
            resultLineId = json.stringValue(forKey: "resultLineId")
            itemid = json.stringValue(forKey: "itemId")
            itemname = json.stringValue(forKey: "itemName")
            
            inbarcode = json.stringValue(forKey: "inCode")
            outbarcode = json.stringValue(forKey: "outCode")
            
            bigitemcatid = json.stringValue(forKey: "bigCategoryId")
            bigitemcatname = json.stringValue(forKey: "bigCategoryName")
            smallitemcatid = json.stringValue(forKey: "smallCategoryId")
            smallitemcatname = json.stringValue(forKey: "smallCategoryName")
            
            guaranteeType = json.stringValue(forKey: "guaranteeType")
            itemEndDate = json.stringValue(forKey: "itemEndDate")
            partsEndDate = json.stringValue(forKey: "partsEndDate")
            
            installDate = json.stringValue(forKey: "installDate")
            buyDate = json.stringValue(forKey: "buyDate")
          
            iemi = json.stringValue(forKey: "iemi")
            
            if let picList = json["resultPicList"] as? [[String:Any]] {
                resultPicList = picList.compactMap({ data in
                    var imageM = ScanImageModel()
                    imageM.picname = data.stringForKey("picName")
                    imageM.ismust = data.stringForKey("isMust")
                    imageM.pic = data.stringForKey("picUrl")
                    
                    return imageM
                })
            }
            
            let dict = json as NSDictionary
            for key in dict.allKeys{
                  if key as! String == "inCode" {
                     //有一码
                      self.hasInCode = true
                  }
                if key as! String == "outCode" {
                   //有二码
                    self.hasOutCode = true
                }
                
                if key as! String == "itemEndDate" {
                    self.hasItemEndDate = true
                }
                
                if key as! String == "partsEndDate" {
                    self.hasPartsEndDate = true
                }
                
                if key as! String == "installDate" {
                    self.hasInstallDate = true
                }
                
                if key as! String == "buyDate" {
                    self.hasBuyDate = true
                }
                
                if key as! String == "barCode3" {
                    self.hasBarCode3 = true
                }
                
                if key as! String == "guaranteeType" {
                    self.hasGuaranteeType = true
                }
                
                if key as! String == "iemi" {
                    self.hasIemi = true
                }
              }
            
        }
        
        //make json
        func jsonValue() -> [String:Any] {
            var param:[String:Any] = [:]
            param["orderLineId"] = orderLineId
            param["resultLineId"] = resultLineId
            param["itemId"] = itemid
            param["itemName"] = itemname
            param["itemCode"] = itemcode
            param["bigCategoryId"] = bigitemcatid
            param["bigCategoryName"] = bigitemcatname
            
            param["smallCategoryId"] = smallitemcatid
            param["smallCategoryName"] = smallitemcatname
            param["inCode"] = inbarcode
           
            if hasOutCode{
                param["outCode"] = outbarcode
            }
            if hasBarCode3{
                param["barCode3"] = barCode3
            }
            if hasItemEndDate {
                param["itemEndDate"] = itemEndDate
            }
            if hasBuyDate{
                param["buyDate"] = buyDate
            }
            
            if hasInstallDate{
                param["installDate"] = installDate
            }
            
            if hasGuaranteeType{
                param["guaranteeType"] = guaranteeType
            }
            
            if hasPartsEndDate
            {
                param["partsEndDate"] = partsEndDate
            }
        
            if hasIemi {
                param["iemi"] = iemi
            }
            
            param["resultPicList"] = resultPicList.compactMap({ (item) -> [String:Any] in
                var picParam = [String:Any]()
                picParam["isMust"] = item.ismust
                picParam["picName"] = item.picname
                picParam["picUrl"] = item.pic
                return picParam
            })
            return param
        }
    }
    
    
    struct ScanImageModel {
        var ismust = "" //是否必填:0否1是
        var picname = ""
        var pic = ""
        var picnametemp = ""
        var picImage = ""
        
        var isNo = ""//不需要这组图片
    }
    
    //自定义字段
    struct M_ShowField {
        var fieldKey = ""
        var fieldName = ""
        var fieldType = ""
        var fieldValue = ""
        
        var isMust = "0"
     
        //选择列表数据
        var fieldValueList = [[String:Any]]()
      
        init(json:[String:Any]) {
            fieldKey = json.stringValue(forKey: "fieldKey")
            fieldName = json.stringValue(forKey: "fieldName")
            fieldType = json.stringValue(forKey: "fieldType")
            fieldValue = json.stringValue(forKey: "fieldValue")
            isMust = json.stringValue(forKey: "isMust")
            if let dataList = json["fieldValueList"] as? [[String:Any]] {
                fieldValueList = dataList
            }
        }
        
        //make json
        func jsonValue() -> [String:Any] {
            var param:[String:Any] = [:]
        
            param["fieldKey"] = fieldKey
            param["fieldName"] = fieldName
            param["fieldType"] = fieldType
            param["fieldValue"] = fieldValue
            return param
        }
    }
    
    //配件
    struct M_Part {

        var num = "0" //编辑的数量
        var qty = ""
        var orderPartsId = ""
        var partsId = ""
        var pic = ""
        
        var partsName = "0"
        var partsCode = ""
        var amount = ""
        
        //选择列表数据
        var maxQty = "0"
        var userPrice = ""
        var partsPic = ""
        
        var invQty = ""
        
        var barcode = ""
        var barcode2 = ""
        
        //旧件信息
        var oldPartsId = ""
        var oldPartsName = ""
        var oldPartsCode = ""
        var oldPic = ""
        
        var selected = false
        
        init(json:[String:Any],isSeleted:Bool=false,isSelectedOld:Bool=false) {
            qty = json.stringForKey("qty")

            orderPartsId = json.stringForKey("orderPartsId")
            partsId = json.stringForKey("partsId")
            
            //图片
            pic = json.stringForKey("pic")
            partsName = json.stringForKey("partsName")
            partsCode = json.stringForKey("partsCode")
            amount = json.stringForKey("amount")
            
            invQty = json.stringForKey("invQty")
            maxQty = json.stringForKey("maxQty")
            userPrice = json.stringForKey("userPrice")
            
            var defalt_num = "0"
            if self.maxQty.intValue() > 0 && self.invQty.intValue() > 0 {
                defalt_num = "1" //默认1
            }
            //选旧件默认1
            if isSelectedOld {
                defalt_num = "1"
            }
            
            num = defalt_num
            
            //读
            if !isSeleted {
                num = json.stringForKey("qty")
                barcode = json.stringForKey("barcode")
                barcode2 = json.stringForKey("barcode2")
                
                //获取旧件信息
                oldPartsId = json.stringForKey("oldPartsId")
                oldPartsName = json.stringForKey("oldPartsName")
                oldPartsCode = json.stringForKey("oldPartsCode")
                oldPic = json.stringForKey("oldPic")
            }
          
            //图片
            partsPic = json.stringForKey("partsPic")
        }
        
        //make json
        func jsonValue() -> [String:Any] {
            var param:[String:Any] = [:]
           
            param["qty"] = num //编辑的数量
            if orderPartsId != ""{
                param["orderPartsId"] = orderPartsId
            }
          
            param["partsId"] = partsId
            param["pic"] = pic
            param["partsName"] = partsName
            param["partsCode"] = partsCode
            param["userPrice"] = userPrice
            param["amount"] = amount
            
            param["invQty"] = invQty
            param["maxQty"] = maxQty
            
            
            
            param["barcode"] = barcode
            param["barcode2"] = barcode2
            //旧件信息
            param["oldPartsId"] = oldPartsId
            param["oldPartsName"] = oldPartsName
            param["oldPartsCode"] = oldPartsCode
            param["oldPic"] = oldPic
            
            return param
        }
    }
    
    struct M_Fault {
        
        var orderFaultId = ""
        
        var symptomName = ""
        var sysmtomId = ""
        
        var reasonId = ""
        var reasonName = ""
        
        var methodName = ""
        var method_id = ""
        var serviceTypeId = ""
        var serviceTypeName = ""
        
        init(json:[String:Any]) {
            orderFaultId = json.stringValue(forKey: "orderFaultId")
            
            symptomName = json.stringValue(forKey: "symptomName")
            sysmtomId = json.stringValue(forKey: "sysmtomId")
            reasonId = json.stringValue(forKey: "reasonId")
            reasonName = json.stringValue(forKey: "reasonName")
            methodName = json.stringValue(forKey: "methodName")
            method_id = json.stringValue(forKey: "methodId")
            serviceTypeId = json.stringValue(forKey: "serviceTypeId")
            serviceTypeName = json.stringValue(forKey: "serviceTypeName")
        }
        
        //make json
        func jsonValue() -> [String:Any] {
            var param:[String:Any] = [:]
            if orderFaultId != ""{
                param["orderFaultId"] = orderFaultId
            }
            param["symptomName"] = symptomName
            param["sysmtomId"] = sysmtomId
            param["reasonId"] = reasonId
            param["reasonName"] = reasonName
            param["methodName"] = methodName
            param["methodId"] = method_id
            param["serviceTypeId"] = serviceTypeId
            param["serviceTypeName"] = serviceTypeName
        
            return param
        }
    }
    
    //费用明细
    struct M_FeeLine {
        var id = ""
        var name = ""
        var value = ""
        var attributeId = ""
        var canWrite = ""
        init(json:[String:Any]) {
            id = json.stringValue(forKey: "id")
            name = json.stringValue(forKey: "name")
            value = json.stringValue(forKey: "value")
            canWrite = json.stringValue(forKey: "canWrite")
            attributeId = json.stringValue(forKey: "attributeId")
        }
        
        //make json
        func jsonValue() -> [String:Any] {
            var param:[String:Any] = [:]
            param["id"] = id
            param["name"] = name
            param["value"] = value
            param["attributeId"] = attributeId

            return param
        }
    }
    
    //费用项列表 -向公司和用户
    struct M_FeeItem {
        var specailFeeId = ""
        var subjectId = ""
        var subjectName = ""
        
        var qty = "1"
        var price = ""
        var amount = ""
        var unit = ""
        
        var selected = false
        
        var isOther = 0
     
        init(json:[String:Any]) {
            specailFeeId = json.stringValue(forKey: "specailFeeId")
            subjectId = json.stringValue(forKey: "subjectId")
            subjectName = json.stringValue(forKey: "subjectName")
            qty = json.stringValue(forKey: "qty")
            let p = json.double("price")
            price = p?.stringValue ?? "0.00"
//            price = json.stringValue(forKey: "price")
            amount = json.stringValue(forKey: "amount")
            unit = json.stringValue(forKey: "unit")
            
            isOther = json.intValue(forKey: "isOther")
        }
        
        //make json
        func jsonValue() -> [String:Any] {
            var param:[String:Any] = [:]
            
            if specailFeeId != "" {
                param["specailFeeId"] = specailFeeId
            }
          
            param["subjectId"] = subjectId
            param["subjectName"] = subjectName
            param["qty"] = qty
            param["price"] = price
            param["amount"] = amount
            param["unit"] = unit
            
            param["isOther"] = isOther
    
            return param
        }
    }
   
}


