//
//  Cell_FinishHeader.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/4.
//

import UIKit

class Cell_FinishHeader: UITableViewCell {
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var btn_right: UIButton!
    @IBOutlet weak var titlebgView: UIView!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        
        let image = UIImage(named: "header_title_bg")
        titlebgView.layer.contents = image?.cgImage
    }
    
    @IBAction func rightAction(_ sender: UIButton) {
        callBack?(sender.titleLabel?.text ?? "")
    }
    

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_FinishHeader: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (String,String)) {
        lab_title.text = data.0
        btn_right.isHidden = data.1 == ""
        btn_right.setTitle(data.1, for: .normal)
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}
