//
//  Cell_FinishOrderItemCode.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/5.
//

import UIKit

class Cell_FinishOrderItemCode: UITableViewCell {
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var btn_scan: UIButton!
    @IBOutlet weak var tf_code: UITextField!
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
    
        tf_code.addTarget(self, action: #selector(self.fieldChanged(theF:)), for: .editingChanged)
        tf_code.addTarget(self, action: #selector(self.fieldChangedEnd(theF:)), for: .editingDidEnd)
    }

    @IBAction func scanAction(_ sender: UIButton) {
        callBack?("扫码")
    }
    
    @objc func fieldChanged(theF:UITextField)  {
        callBack?((UIControl.Event.editingChanged,theF.text ?? ""))
    }
    
    @objc func fieldChangedEnd(theF:UITextField)  {
        callBack?((UIControl.Event.editingDidEnd,theF.text ?? ""))
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_FinishOrderItemCode: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String,String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        tf_code.isEnabled = data.canEdit
    }
    
    func row_update(dataSource data: (String,String,String)) {
        tf_code.text = data.0
        lab_title.text = data.1
        tf_code.placeholder = data.2
    }
    
}
