//
//  Cell_FinishOrderShowMore.swift
//  VattiCSS
//
//  Created by Jan on 2024/1/5.
//

import UIKit


class Cell_FinishOrderShowMore: UITableViewCell {
    @IBOutlet weak var btn_right: UIButton!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        
        btn_right.imageEdgeInsets = UIEdgeInsets(top: 0, left: 8, bottom: 0, right: 0)
        btn_right.semanticContentAttribute = .forceRightToLeft
        btn_right.contentHorizontalAlignment = .center
    }
    
    @IBAction func rightAction(_ sender: UIButton) {
        callBack?(sender.titleLabel?.text ?? "")
    }
    

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_FinishOrderShowMore: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,Bool)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (String,Bool)) {
        let image = UIImage(named: data.1 == true ? "icon_arrow_upward" : "icon_arrow_downward")
        btn_right.setImage(image, for: .normal)
        btn_right.setTitle(data.0, for: .normal)
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}

