//
//  Cell_FinishState.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/4.
//

import UIKit

class Cell_FinishState: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var btn_item1: UIButton!
    @IBOutlet weak var btn_item2: UIButton!
    @IBOutlet weak var btn_item3: UIButton!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        btn_item1.imageEdgeInsets = UIEdgeInsets(top: 0, left: -2, bottom: 0, right: 0)
        btn_item2.imageEdgeInsets = UIEdgeInsets(top: 0, left: -2, bottom: 0, right: 0)
        btn_item3.imageEdgeInsets = UIEdgeInsets(top: 0, left: -2, bottom: 0, right: 0)
        
        btn_item1.setTitle("正常完工".languageString(), for: .normal)
        btn_item2.setTitle("无法完工".languageString(), for: .normal)
        btn_item3.setTitle("需再次服务".languageString(), for: .normal)
    }

    @IBAction func clickAction(_ sender: UIButton) {
        callBack?(sender.tag)
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_FinishState: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (String)) {
        let type = data
        switch type {
        case "1":
            btn_item1.setImage(UIImage(named: "hep_radiobox_selected"), for: .normal)
            btn_item2.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
            btn_item3.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
            break
        case "2":
            btn_item2.setImage(UIImage(named: "hep_radiobox_selected"), for: .normal)
            btn_item1.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
            btn_item3.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
            break
        case "3":
            btn_item3.setImage(UIImage(named: "hep_radiobox_selected"), for: .normal)
            btn_item2.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
            btn_item1.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
            break
        default:
            btn_item3.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
            btn_item2.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
            btn_item1.setImage(UIImage(named: "hep_radiobox_normal"), for: .normal)
            break
        }
        
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}

