//
//  Cell_FinishOrderFeeCode.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/18.
//

import UIKit

class Cell_FinishOrderFeeCode: UITableViewCell {
    
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var tf_input: UITextField!
    @IBOutlet weak var btn_right: UIButton!
    @IBOutlet weak var lab_userMobile: UILabel!
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        btn_right.titleLabel?.text = "获取验证码".languageString()
        lab_title.text = "请向用户获取费用验证码以核实收费".languageString()
        btn_right.isHidden = false
        
        tf_input.addTarget(self, action: #selector(self.fieldChanged(theF:)), for: .editingChanged)
        tf_input.addTarget(self, action: #selector(self.fieldChangedEnd(theF:)), for: .editingDidEnd)
        
        MineGetCodeTool.defaultTool().setupCodeBtnCall { [weak self] (curTimeNumber) in
            guard let weakSelf = self else { return }
            guard let curCodeBtn = weakSelf.btn_right else { return }
            var btnTitleStr = "获取验证码".languageString()
            curCodeBtn.isEnabled = (curTimeNumber <= 0)
            if curTimeNumber > 0 {
                btnTitleStr = "重新发送".languageString()+"(\(curTimeNumber))"
            }
            curCodeBtn.setTitle(btnTitleStr, for: UIControl.State.normal)
        }
    }
    
    @IBAction func getCodeAction(_ sender: UIButton) {
        callBack?("获取验证码")
    }
    

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @objc func fieldChanged(theF:UITextField)  {
        callBack?((UIControl.Event.editingChanged,theF.text ?? ""))
    }
    
    @objc func fieldChangedEnd(theF:UITextField)  {
        callBack?((UIControl.Event.editingDidEnd,theF.text ?? ""))
    }
    
}


extension Cell_FinishOrderFeeCode: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
    
    }
    
    func row_update(dataSource data: (String,String,String)) {
        lab_userMobile.text = data.0
        tf_input.text = data.1
        tf_input.placeholder = data.2
    }
    
}
