//
//  Cell_FinishOrderFeeImages.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/13.
//

import UIKit

class Cell_FinishOrderFeeImages: UITableViewCell {
    @IBOutlet weak var lab_title: UILabel!
    
    @IBOutlet weak var bgView1: UIView!
    @IBOutlet weak var btn_add1: UIButton!
    @IBOutlet weak var img_1: UIImageView!
    
    @IBOutlet weak var bgView2: UIView!
    @IBOutlet weak var btn_add2: UIButton!
    @IBOutlet weak var img_2: UIImageView!
    
    @IBOutlet weak var bgView3: UIView!
    @IBOutlet weak var btn_add3: UIButton!
    @IBOutlet weak var img_3: UIImageView!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        
        let tap1 = UITapGestureRecognizer(target: self, action: #selector(imageChange(_:)))
        img_1.addGestureRecognizer(tap1)
        img_1.isUserInteractionEnabled = true
        
        let tap2 = UITapGestureRecognizer(target: self, action: #selector(imageChange(_:)))
        img_2.addGestureRecognizer(tap2)
        img_2.isUserInteractionEnabled = true
        
        let tap3 = UITapGestureRecognizer(target: self, action: #selector(imageChange(_:)))
        img_3.addGestureRecognizer(tap3)
        img_3.isUserInteractionEnabled = true
        
        lab_title.text = "凭证".languageString()
    }
    
    
    @objc func imageChange(_ sender:UITapGestureRecognizer){
        if sender.view == img_1{
            callBack?(1)
        } else if sender.view == img_2{
            callBack?(2)
        } else if sender.view == img_3{
            callBack?(3)
        }
       
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    @IBAction func addAction(_ sender: UIButton) {
        callBack?(sender.tag)
    }
}

extension Cell_FinishOrderFeeImages: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (String,String,String)) {
        if data.0 != ""{
            btn_add1.isHidden = true
            img_1.sd_setImage(with: URL(string: data.0))
        }else{
            btn_add1.isHidden = false
            img_1.sd_setImage(with: URL(string: ""))
        }
        
        if data.1 != ""{
            btn_add2.isHidden = true
            bgView2.isHidden = false
            img_2.isHidden = false
            img_2.sd_setImage(with: URL(string: data.1))
            
        }else{
            bgView2.isHidden = true
            btn_add2.isHidden = true
            img_2.isHidden = true
            img_2.sd_setImage(with: URL(string: ""))
        }
        
        if data.2 != ""{
            btn_add3.isHidden = true
            bgView3.isHidden = false
            img_3.isHidden = false
            img_3.sd_setImage(with: URL(string: data.2))
           
        }else{
            bgView3.isHidden = true
            btn_add3.isHidden = true
            img_3.isHidden = true
            img_3.sd_setImage(with: URL(string: ""))
        }
        
        //配置选图 选择1图，显示2图位
        bgView2.isHidden = data.0 == ""
        img_2.isHidden = data.0 == ""
        btn_add2.isHidden = data.0 == ""
        
        bgView3.isHidden = data.1 == ""
        img_3.isHidden = data.1 == ""
        btn_add3.isHidden = data.0 == ""
        
        
        img_1.layer.cornerRadius = 8
        img_1.layer.masksToBounds = true
        img_2.layer.cornerRadius = 8
        img_2.layer.masksToBounds = true
        img_3.layer.cornerRadius = 8
        img_3.layer.masksToBounds = true

    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}
