//
//  Cell_FinishOrderFeeInputTitle.swift
//  VattiCSS
//
//  Created by Jan on 2024/2/26.
//

import UIKit


class Cell_FinishOrderFeeInputTitle: UITableViewCell {
    @IBOutlet weak var lab_title: UILabel!
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func editAction(_ sender: UIButton) {
        showAlert()
    }
    
    func showAlert() {
        let alert = UIAlertController(title: "", message: "", preferredStyle: .alert)
        alert.addTextField { tf in
            tf.placeholder = "请输入费用名称"
        }
        let action1 = UIAlertAction(title: "取消", style: .cancel) {_ in
            alert.dismiss(animated: true)
        }
        action1.setValue(UIColor(hexString: "D0D0D1"), forKey: "titleTextColor")
        
        let action2 = UIAlertAction(title: "确定", style: .default) {[weak self] ac in
            guard let weakSelf = self else { return }
            let text = alert.textFields!.first?.text
            if !text!.isEmpty {
                weakSelf.callBack?(("editTitle",text))
            }
            alert.dismiss(animated: true)
        }
        action2.setValue(UIColor(hexString: "00c4b3"), forKey: "titleTextColor")
        
        alert.addAction(action1)
        alert.addAction(action2)
        CD.visibleVC?.present(alert, animated: true)
    }
    
}


extension Cell_FinishOrderFeeInputTitle: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (String,String)) {
        lab_title.text = data.0
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        self.callBack = block
    }
    
}
