//
//  Cell_FinishOrderFeeNumInput.swift
//  VattiCSS
//
//  Created by Jan on 2024/2/26.
//

import UIKit

class Cell_FinishOrderFeeNumInput: UITableViewCell,UITextFieldDelegate {
    @IBOutlet weak var qtyView: UIView!
    @IBOutlet weak var qtyTF: UITextField!
    @IBOutlet weak var subBtn: UIButton!
    @IBOutlet weak var addBtn: UIButton!
    @IBOutlet weak var lab_amount: UILabel!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    
    @IBAction func editPriceAction(_ sender: UIButton) {
        showAlert()
    }
    
    @IBAction func editingDidEnd(_ sender: UITextField) {
        if sender == qtyTF {
            let qty = sender.text!.intValue()
            if qty < 1 {
                sender.text = "1"
                callBack?(1)
            }else{
                callBack?(sender.text!.intValue())
            }
        }
    }
    
    @IBAction func clickBtn(_ sender: UIButton) {
        var qty = qtyTF.text!.intValue()
        if sender.tag == 1 {
            qty += 1
        }else{
            if qty > 1 {
                qty -= 1
            }
        }
        qtyTF.text = "\(qty)"
        callBack?(qty)
    }
    
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        if range.length >= 1 {
            return true
        }
        if !self.checkDecimal(textField.text!.appending(string)) {
            if (textField.text!.count > 0 && string == "." && !textField.text!.contains(".")) {
                return true
            }
            return false
        }
        return true
    }
    
    func checkDecimal(_ str:String) -> Bool {
        let regex = "^[0-9]+(\\.[0-9]{1,2})?$"
        let pred = NSPredicate(format: "SELF MATCHES %@", regex)
        if pred.evaluate(with: str) {
            return true
        }else{
            return false
        }
    }
    
    func showAlert() {
        let alert = UIAlertController(title: "", message: "", preferredStyle: .alert)
        alert.addTextField { tf in
            tf.placeholder = "请输入单价"
            tf.delegate = self
        }
        let action1 = UIAlertAction(title: "取消", style: .cancel) {_ in
            alert.dismiss(animated: true)
        }
        action1.setValue(UIColor(hexString: "D0D0D1"), forKey: "titleTextColor")
     
        let action2 = UIAlertAction(title: "确定", style: .default) {[weak self] ac in
            guard let weakSelf = self else { return }
            let text = alert.textFields!.first?.text
            if !text!.isEmpty {
                weakSelf.callBack?(("editPrice",text))
            }
            alert.dismiss(animated: true)
        }
        
        action2.setValue(UIColor(hexString: "00c4b3"), forKey: "titleTextColor")
        
        alert.addAction(action1)
        alert.addAction(action2)
        CD.visibleVC?.present(alert, animated: true)
    }
}

extension Cell_FinishOrderFeeNumInput: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (String,String,String)) {
        lab_amount.text = "¥ "+data.0+"元/"+data.2
        qtyTF.text = data.1
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}


