//
//  Cell_FinishOrderFeeRemark.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/13.
//

import UIKit

class Cell_FinishOrderFeeRemark: UITableViewCell,UITextViewDelegate {
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var textView: UITextView!
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        
        self.selectionStyle = .none
        textView.delegate = self
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    func textViewDidChange(_ textView: UITextView) {
        callBack?((UIControl.Event.editingChanged,textView.text ?? ""))
    }
    
    func textViewDidEndEditing(_ textView: UITextView) {
        callBack?((textView.text ?? ""))
    }
    
}


extension Cell_FinishOrderFeeRemark: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
        textView.isEditable = data.canEdit
        textView.placeholder = data.canEdit ? "请输入".languageString() : ""
    }
    
    func row_update(dataSource data: (String,String)) {
        lab_title.text = data.1
        textView.text = data.0
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}
