//
//  Cell_FinishOrderFeeTotal.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/14.
//

import UIKit

class Cell_FinishOrderFeeTotal: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var lineView: UIView!
    @IBOutlet weak var lab_amount1: UILabel!
    @IBOutlet weak var tf_amount2: UITextField!
    @IBOutlet weak var lab_amount3: UILabel!
    
    @IBOutlet weak var lab_all: UILabel!
    @IBOutlet weak var lab_discounts: UILabel!
    @IBOutlet weak var lab_actua: UILabel!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
//        let image = UIImage(named: "finish_part_bg")
//        self.bgView.layer.contents = image?.cgImage
        
        lab_all.text = "费用总金额".languageString()
        lab_discounts.text = "优惠总金额".languageString()
        lab_actua.text = "合计".languageString()+":"
        
        self.lineView.backgroundColor = .clear
        self.lineView.drawDashLine(CGRect(x: 0, y: 0, width: SCREEN_W-50, height: 0.5), strokeColor: UIColor(hexString: "C7C7CC"), lineWidth: 0.5, lineLength: 6, lineSpacing: 6)
        
        tf_amount2.addTarget(self, action: #selector(self.fieldChanged(theF:)), for: .editingChanged)
        tf_amount2.addTarget(self, action: #selector(self.fieldChangedEnd(theF:)), for: .editingDidEnd)
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @objc func fieldChanged(theF:UITextField)  {
        callBack?((UIControl.Event.editingChanged,theF.text ?? ""))
    }
    
    @objc func fieldChangedEnd(theF:UITextField)  {
        callBack?((UIControl.Event.editingDidEnd,theF.text ?? ""))
    }
    
}


extension Cell_FinishOrderFeeTotal: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
        tf_amount2.isEnabled = data.canEdit
        if data.canEdit {
            tf_amount2.placeholder = "请输入".languageString()
        }else{
            tf_amount2.placeholder = ""
        }
    }
    
    func row_update(dataSource data: (String,String,String)) {
        if data.0 == ""{
            lab_amount1.text = "¥0.00"
        }else{
            lab_amount1.text = "¥"+data.0
        }
        
        tf_amount2.text = data.1
        lab_amount3.text = "¥"+data.2
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}

