//
//  Cell_FinishFeesCategory.swift
//  VattiCSS
//
//  Created by WZR on 2024/1/3.
//

import UIKit

class Cell_FinishFeesCategory: UITableViewCell {

    @IBOutlet weak var view_bg: UIView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var view_select: UIView!
    
    var corner:(UIRectCorner, CGFloat) = ([],0)
    override func awakeFromNib() {
        super.awakeFromNib()
        
        lab_title.cd
            .text("")
            .text(Config.color.hex("3"))
        view_select.cd.background(KMainColour)
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        view_bg.cd.rounded(corner.0, CGSize(w:corner.1, h: corner.1))
    }
}
extension Cell_FinishFeesCategory: CD_RowCellUpdateProtocol {
    typealias DataSource = M_FinishFeesCategory
    typealias ConfigModel = (UIRectCorner, CGFloat)
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data.bigTypeName)
            .text(data.select ? KMainColour : Config.color.hex("3"))
            .text(Config.font.fontMedium(14, fit: true))
        view_bg.cd.background(data.select ? Config.color.hex("f") : Config.color.hex("f8"))
        view_select.isHidden = !data.select
    }
    
    func row_update(config data: (UIRectCorner, CGFloat)) {
        corner = data
        view_bg.cd.rounded(corner.0, CGSize(w:corner.1, h: corner.1))
    }
}
