//
//  Cell_FinishPartCode.swift
//  VattiCSS
//
//  Created by Jan on 2023/11/16.
//

import UIKit

class Cell_FinishPartCode: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var btn_code: UIButton!
    @IBOutlet weak var tf_code: UITextField!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        btn_code.imageEdgeInsets = UIEdgeInsets(top: 0, left: -5, bottom: 0, right: 0)
        tf_code.addTarget(self, action: #selector(self.fieldChangedEnd(theF:)), for: .editingDidEnd)
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func scanCodeAction(_ sender: UIButton) {
        callBack?("打开扫码")
    }
    
    
    @objc func fieldChangedEnd(theF:UITextField)  {
        callBack?(theF.text ?? "")
    }
}


extension Cell_FinishPartCode: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
        bgView.backgroundColor = data.bgColor
    }
    
    func row_update(dataSource data: (String,String)) {
        btn_code.setTitle(data.0, for: .normal)
        tf_code.text = data.1
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}
