//
//  Cell_FinishPartInfo.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/11.
//

import UIKit

class Cell_FinishPartInfo: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var btn_icon: UIButton!
    @IBOutlet weak var lab_name: UILabel!
    @IBOutlet weak var lab_code: UILabel!
    @IBOutlet weak var btn_tag: UIButton!
    @IBOutlet weak var btn_selOldPart: UIButton!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        
        bgView.makeLayerRadius(value: 5,type: [.layerMinXMinYCorner,.layerMaxXMinYCorner])
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func selOldPartAction(_ sender: UIButton) {
        callBack?("")
    }
    
    
}


extension Cell_FinishPartInfo: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
        bgView.backgroundColor = data.bgColor
        btn_tag.setImage(UIImage(named: data.nextViewImageStr), for: .normal)
        
        if data.nextViewImageStr == "tag_old_accessory"{
            //显示选旧件
            btn_selOldPart.isHidden = false
        }else{
            btn_selOldPart.isHidden = true
        }
    }
    
    func row_update(dataSource data: (String,String,String)) {
        lab_name.text = data.0
        lab_code.text = "配件编码".languageString()+": "+data.1
        btn_icon.sd_setImage(with: URL(string: data.2), for: .normal, placeholderImage: UIImage(named: "parts_default"), context: nil)
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}
