//
//  Cell_FinishPartNum.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/11.
//

import UIKit

class Cell_FinishPartNum: UITableViewCell {

    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var leftView: UIView!
    @IBOutlet weak var rightView: UIView!
    
    @IBOutlet weak var qtyView: UIView!
    @IBOutlet weak var qtyTF: UITextField!
    @IBOutlet weak var subBtn: UIButton!
    @IBOutlet weak var addBtn: UIButton!
    
    @IBOutlet weak var lab_amount: UILabel!
    
    var callBack: TCRowCallBack?
    var maxQty = 0
    var intQty = 0
    var numStr = ""
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code  login_bg
//        
//        let image = UIImage(named: "finish_part_bg")
//        self.leftView.layer.contents = image?.cgImage
//        self.rightView.layer.contents = image?.cgImage
        
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    
    
    @IBAction func editingDidEnd(_ sender: UITextField) {
        if sender == qtyTF {
            let qty = sender.text!.intValue()
            if qty < 1 {
                sender.text = "0"
                callBack?(0)
            }else{
                if qty > maxQty{
                    qtyTF.text = numStr
                    SVProgressHUD.showError(withStatus: "不能大于最大更换数量\(maxQty)!")
                    return
                }
                
                if qty > intQty{
                    qtyTF.text = numStr
                    SVProgressHUD.showError(withStatus: "不能大于库存数量\(intQty)!")
                    return
                }
                
                callBack?(sender.text!.intValue())
            }
        }
    }
    
    @IBAction func clickBtn(_ sender: UIButton) {
        var qty = qtyTF.text!.intValue()
        if sender.tag == 1 {
            qty += 1
            if qty > maxQty{
                qtyTF.text = numStr
                SVProgressHUD.showError(withStatus: "不能大于最大更换数量\(maxQty)!")
                return
            }
            if qty > intQty{
                qtyTF.text = numStr
                SVProgressHUD.showError(withStatus: "不能大于库存数量\(intQty)!")
                return
            }
           
        }else{
            if qty > 0 {
                qty -= 1
            }
        }
        qtyTF.text = "\(qty)"
        callBack?(qty)
    }
    
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        if range.length >= 1 {
            return true
        }
        if !self.checkDecimal(textField.text!.appending(string)) {
            if (textField.text!.count > 0 && string == "." && !textField.text!.contains(".")) {
                return true
            }
            return false
        }
        return true
    }
    
    func checkDecimal(_ str:String) -> Bool {
        let regex = "^[0-9]+(\\.[0-9]{1,2})?$"
        let pred = NSPredicate(format: "SELF MATCHES %@", regex)
        if pred.evaluate(with: str) {
            return true
        }else{
            return false
        }
    }
}



extension Cell_FinishPartNum: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String,String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
        if data.canEdit {
            qtyTF.isEnabled = true
            subBtn.isUserInteractionEnabled = true
            addBtn.isUserInteractionEnabled = true
        }
        else{
            qtyTF.isEnabled = false
            subBtn.isUserInteractionEnabled = false
            addBtn.isUserInteractionEnabled = false
        }
    }
    
    func row_update(dataSource data: (String,String,String,String)) {
        lab_amount.text = "¥ "+data.0
        qtyTF.text = data.1
        maxQty = data.2.intValue()
        intQty = data.3.intValue()
        numStr = data.1
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}
