//
//  FinishOrderAlertVc.swift
//  VattiCSS
//
//  Created by Jan on 2024/1/18.
//

import UIKit

extension FinishOrderAlertVc {
    public class func show(_ visibleVC:UIViewController,title:String,message:String, preferredStyle:FinishOrderAlertVc.Style = .normal, callback:((ActionStyle)->Void)? = nil) {
        let vc = UIStoryboard(name: "FinishOrder", bundle: nil).instantiateViewController(withIdentifier: "FinishOrderAlertVc") as! FinishOrderAlertVc
        vc.preferredStyle = preferredStyle
        vc.callback = callback
        vc.alertTitle = title
        vc.message = message
        vc.modalTransitionStyle = .crossDissolve
        vc.modalPresentationStyle = .custom
        visibleVC.present(vc, animated: true, completion: nil)
    }
}

class FinishOrderAlertVc: UIViewController {
    public enum Style {
        case more //标题，提示文本，关闭，左右底部按钮
        case normal //标题，提示文本，左右底部按钮
        case msg //标题，提示文本，确定底部按钮
        case simple //提示文本，确定底部按钮
    }
   
    public enum ActionStyle {
        case left
        case right
        case sure
        case close
    }
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var leftButton: UIButton!
    @IBOutlet weak var rightButton: UIButton!
    @IBOutlet weak var msgLabel: UILabel!
    @IBOutlet weak var closeButton: UIButton!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var bottomItemSeparatorView: UIView!
    @IBOutlet weak var sureButton: UIButton!
    @IBOutlet weak var bottomView: UIView!

    var preferredStyle:Style = .normal
    var callback:((ActionStyle)->Void)?
    public var alertTitle: String?
    public var message: String?
    override func viewDidLoad() {
        super.viewDidLoad()
        
        leftButton.setTitle("取消".languageString(), for: .normal)
        rightButton.setTitle("确定".languageString(), for: .normal)

        bgView.layer.cornerRadius = 5
        bgView.layer.masksToBounds = true
        
        self.view.backgroundColor = UIColor.black.withAlphaComponent(0.3)
        switch preferredStyle {
        case .normal:
            makeNormalUI()
        case .simple:
            makeSimpleUI()
        case .more:
            makeMoreUI()
        case .msg:
            makeMsgUI()
        }
    }
    
    func makeNormalUI(){
        self.titleLabel.isHidden = false
        self.titleLabel.text = self.alertTitle
        self.msgLabel.text = self.message
    }
    
    func makeMsgUI(){
        closeButton.isHidden = true
        leftButton.isHidden = true
        rightButton.isHidden = true
        bottomItemSeparatorView.isHidden = true
        
        sureButton.isHidden = false
        self.titleLabel.isHidden = false
        bottomView.bringSubviewToFront(sureButton)
        
        self.titleLabel.text = self.alertTitle
        self.msgLabel.text = self.message
    }
    
    func makeSimpleUI(){
        closeButton.isHidden = true
        leftButton.isHidden = true
        rightButton.isHidden = true
        bottomItemSeparatorView.isHidden = true
        
        sureButton.isHidden = false
        bottomView.bringSubviewToFront(sureButton)
        
        self.titleLabel.text = self.alertTitle
        self.msgLabel.text = self.message
    }
    
    func makeMoreUI(){
        closeButton.isHidden = false
        self.titleLabel.isHidden = false
        self.titleLabel.text = self.alertTitle
        self.msgLabel.text = self.message
    }
    
    @IBAction func leftButtonClick(_ sender: UIButton) {
        callback?(ActionStyle.left)
        dissAlert()
    }
    
    @IBAction func rightButtonClick(_ sender: UIButton) {
        callback?(ActionStyle.right)
        dissAlert()
    }
    
    @IBAction func closeButtonClick(_ sender: UIButton) {
        self.dismiss(animated: true) {
            self.callback?(ActionStyle.close)
        }
    }
    
    @IBAction func sureButtonClick(_ sender: UIButton) {
        callback?(ActionStyle.sure)
        dissAlert()
    }
    
    func dissAlert(){
        self.dismiss(animated: true, completion: nil)
    }
    
}
