//
//  FinishOrdeFeeVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/4.
//

import UIKit

class FinishOrdeFeeVm: NSObject {

    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var model = M_FinishOrder(json: [:])
    var disSelectCallback:(([String:Any])->())?
    var imageCallback:((Bool,Int)->())?
    var addCallback:((Int)->())? //新增费用项目
    var getCodeCallback:((String)->())?
    
    var canEdit = true
    
    var isShowMore = false
    
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []

        newForms += makeInfoForms()
        newForms += makeCompanyForms()
        newForms += makeUserForms()
        
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        //header
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("本单服务费用".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        //固定费用
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .showLine(false)
                .title("服务费用".languageString())
                .bgColor(UIColor(hexString: "f8f8f8"))
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "999999"))
                .infoColor(UIColor(hexString: "333333"))
                .showLine(false)
            
            let value = model.siteAmount == "" ? "0.0" : model.siteAmount
            let rowCell = TCFormCellModel<TCTextLineCell>.init(data: (80, "¥"+value, "",12,12), config: uiConfigModel, id: nil, frameh: 30, didSelect:  {[weak self] in
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .showLine(false)
                .title("奖罚金额".languageString())
                .bgColor(UIColor(hexString: "f8f8f8"))
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "999999"))
                .infoColor(UIColor(hexString: "333333"))
                .showLine(false)
            
            var rewardReason = ""
            if rewardReason != "" {
                rewardReason = "/"+model.rewardReason
            }
            let value = model.rewardAmount == "" ? "0.0" : model.rewardAmount
            let rowCell = TCFormCellModel<TCTextLineCell>.init(data: (80, "¥"+value+rewardReason, "",12,12), config: uiConfigModel, id: nil, frameh: 30, didSelect:  {[weak self] in
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .showLine(false)
                .title("远程补贴".languageString())
                .bgColor(UIColor(hexString: "f8f8f8"))
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "999999"))
                .infoColor(UIColor(hexString: "333333"))
                .showLine(false)
            
            let value = model.longDistanceAmount == "" ? "0.0" : model.longDistanceAmount
            let distance = model.longDistance == "" ? "0" : model.longDistance
            let rowCell = TCFormCellModel<TCTextLineCell>.init(data: (80, distance+"公里".languageString()+"/¥"+value, "",12,12), config: uiConfigModel, id: nil, frameh: 30, didSelect:  {[weak self] in
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .showLine(false)
                .title("特设费用".languageString())
                .bgColor(UIColor(hexString: "f8f8f8"))
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "999999"))
                .infoColor(UIColor(hexString: "333333"))
                .showLine(false)
            
            let value = model.specailAmount == "" ? "0.0" : model.specailAmount
            let rowCell = TCFormCellModel<TCTextLineCell>.init(data: (80, "¥"+value, "",12,12), config: uiConfigModel, id: nil, frameh: 30, didSelect:  {[weak self] in
            })
            newForms.append(rowCell)
        }
        
        //自定义费用
        for (index,item) in self.model.showFeeList.enumerated() {
            if item.canWrite == ""{
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                        .showLine(false)
                        .title(item.name)
                        .bgColor(UIColor(hexString: "f8f8f8"))
                        .titleFont(UIFont.systemFont(ofSize: 14))
                        .titleColor(UIColor(hexString: "999999"))
                        .infoColor(UIColor(hexString: "333333"))
                        .showLine(false)
                    let rowCell = TCFormCellModel<TCTextLineCell>.init(data: (80, item.value, "",12,12), config: uiConfigModel, id: nil, frameh: 30, didSelect:  {[weak self] in
                    })
                    newForms.append(rowCell)
                }
            }else{
                do {
                    let placeholderText = !canEdit ? "" : "请输入".languageString()
                    
                    let cfModel = TCFormCellConfigModel(titleStr: item.name).showTip(false).setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                        .infoColor(UIColor(hexString: "#333333"))
                        .infoFont(UIFont.systemFont(ofSize: 14))
                        .bgColor(UIColor.white)
                        .setCellColor(UIColor(hexString: "f8f8f8"))
                        .titleColor(UIColor.init(hexString: "999999"))
                        .textAlignment(.right)
                        .showLine(false)
                        .canEdit(canEdit)
                        .unitText(placeholderText)
                    
                    let rowCell = TCFormCellModel<Cell_FinishOrderFeeInput>.init(data: (80, item.value, placeholderText, nil, nil), config: cfModel, id: nil, frameh: 40, callBack: { [weak self] callValue in
                        guard let weakSelf = self else { return }
                        guard weakSelf.canEdit else {
                            return
                        }
                        if let cValue = callValue as? (UIControl.Event, String) {
                            if cValue.0 == .editingChanged  {
                                var newItem = item
                                newItem.value = cValue.1
                                self?.model.showFeeList[index] = newItem
                               
                            }else if cValue.0 == .editingDidEnd  {
                                self?.makeForms()
                            }
                        }
                    }, didSelect: nil)
                    newForms.append(rowCell)
                }
            }
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(UIColor.white)
                .setCellColor(UIColor(hexString: "f8f8f8"))
                .setBgViewLeading(12)
                .setBgViewTrailing(12)
        
            let rowCell = TCFormCellModel<Cell_DottedLine>.init(data: (1,UIColor(hexString: "C7C7CC")), config: uiConfigModel, id: nil, frameh: 20)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .showLine(false)
                .title("合计".languageString())
                .bgColor(UIColor(hexString: "f8f8f8"))
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "999999"))
                .infoColor(UIColor(hexString: "333333"))
                .infoFont(UIFont.boldSystemFont(ofSize: 18))
            
            let amount = self.model.showFeeList.map{(Float($0.value) ?? 0.00 * 1)}.reduce(0, +)
            let allAmount = (Float(self.model.siteFinalAmount) ?? 0.00)+amount
            
            let rowCell = TCFormCellModel<TCTextLineCell>.init(data: (70, "¥"+allAmount.stringValue, "",12,12), config: uiConfigModel, id: nil, frameh: 30, didSelect:  {[weak self] in
            })
            newForms.append(rowCell)
        }
        
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
    
    
    func makeCompanyForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        //header
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let actionName = canEdit ? "新增".languageString() : ""
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("向公司申请特设费用".languageString(),actionName), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                guard let weakSelf = self else { return }
                guard weakSelf.canEdit else {
                    return
                }
                weakSelf.addCallback?(1)
            }
            newForms.append(rowCell)
        }
        
        //展开更多
        if isShowMore{
            
            for (index,item) in model.specailFeeList.enumerated() {
                
                do {
                    let value1 = item.subjectName
                    let value2 = ""
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    let rowCell = TCFormCellModel<Cell_FinishOrderFeeTitle>.init(data: (value1,value2), config: uiConfigModel, id: nil, frameh: 40) { a in
                    }
                    newForms.append(rowCell)
                }
                
                do {
                    let value1 = item.price
                    let value2 = item.qty
                    let value3 = item.unit
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    let rowCell = TCFormCellModel<Cell_FinishOrderFeeNum>.init(data: (value1,value2,value3), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                        if let thrQty = a as? Int {
                            var newItem = item
                            newItem.qty = thrQty.stringValue
                            newItem.amount = String(format: "%.2f", item.price.floatValue())
                            self?.model.specailFeeList[index] = newItem
                            self?.makeForms()
                        }
                    }
                    newForms.append(rowCell)
                }
                
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    let rowCell = TCFormCellModel<Cell_FinishPartDelete>.init(data: ("",""), config: uiConfigModel, id: nil, frameh: 47) {[weak self] a in
                        guard let weakSelf = self else { return }
                        guard weakSelf.canEdit else {
                            return
                        }
                        weakSelf.model.specailFeeList.remove(at: index)
                        weakSelf.makeForms()
                    }
                    newForms.append(rowCell)
                }
                
            }
            
            //备注模块
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                uiConfigModel.canEdit(canEdit)
                let rowCell = TCFormCellModel<Cell_FinishOrderFeeRemark>.init(data: (self.model.specailAmountRemark,"申请理由".languageString()), config: uiConfigModel, id: nil, frameh: 120) {  [weak self] callValue in
                    guard let weakSelf = self else { return }
                    guard weakSelf.canEdit else {
                        return
                    }
                    if let value = callValue as? (UIControl.Event,String) {
                        weakSelf.model.specailAmountRemark = value.1
                    }
                    
                    if let value = callValue as? String {
                        weakSelf.model.specailAmountRemark = value
                        weakSelf.makeForms()
                    }
                }
                newForms.append(rowCell)
            }
            
            
            //图片模块
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let pic1 = kGetServerPicUrl(model.specailAmountPic1)
                let pic2 = kGetServerPicUrl(model.specailAmountPic2)
                let pic3 = kGetServerPicUrl(model.specailAmountPic3)
                
                
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_FinishOrderFeeImages>.init(data: (pic1,pic2,pic3), config: uiConfigModel, id: nil, frameh: 144) {[weak self] (a) in
                    if let theTag = a as? Int {
                        self?.imageCallback?(false,theTag)
                    }
                    
                }
                newForms.append(rowCell)
            }
        }
      
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let actionName = !isShowMore ? "点击展开".languageString() : "点击收起".languageString()
            let rowCell = TCFormCellModel<Cell_FinishOrderShowMore>.init(data: (actionName,self.isShowMore), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                guard let weakSelf = self else { return }
                let isShow = weakSelf.isShowMore
                weakSelf.isShowMore = !isShow
                weakSelf.makeForms()
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
    

    func makeUserForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        //header
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let actionName = canEdit ? "新增".languageString() : ""
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("向用户收取费用".languageString(),actionName), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                guard let weakSelf = self else { return }
                guard weakSelf.canEdit else {
                    return
                }
                weakSelf.addCallback?(2)
            }
            newForms.append(rowCell)
        }
        
        for (index,item) in model.userPayList.enumerated() {
            
            //可编辑费用名称
            if item.isOther == 1{
                do {
                    let value1 = item.subjectName
                    let value2 = ""
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    let rowCell = TCFormCellModel<Cell_FinishOrderFeeInputTitle>.init(data: (value1,value2), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                        //修改标题
                        if let action = a as? (String,String) {
                            if action.0 == "editTitle" {
                                var newItem = item
                                
                                let subjectName = action.1
                               
                                newItem.subjectName = subjectName
                                self?.model.userPayList[index] = newItem
                                self?.setUserAmount()
                                self?.makeForms()
                            }
                        }
                    }
                    newForms.append(rowCell)
                }
                
            
            }else{
                do {
                    let value1 = item.subjectName
                    let value2 = ""
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    let rowCell = TCFormCellModel<Cell_FinishOrderFeeTitle>.init(data: (value1,value2), config: uiConfigModel, id: nil, frameh: 40) { a in
                    }
                    newForms.append(rowCell)
                }
            }
                
            //可编辑费用价格
            if item.isOther == 1 {
                do {
                    let value1 = item.price
                    let value2 = item.qty
                    let value3 = item.unit
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    let rowCell = TCFormCellModel<Cell_FinishOrderFeeNumInput>.init(data: (value1,value2,value3), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                        
                        if let thrQty = a as? Int {
                            var newItem = item
                            newItem.qty = thrQty.stringValue
                            newItem.amount = String(format: "%.2f", item.price.floatValue())
                            self?.model.userPayList[index] = newItem
                            self?.setUserAmount()
                            self?.makeForms()
                        }
                        else{
                            //修改单价
                            if let action = a as? (String,String) {
                                if action.0 == "editPrice" {
                                    var newItem = item
                                    newItem.price = action.1
                                    self?.model.userPayList[index] = newItem
                                    self?.setUserAmount()
                                    self?.makeForms()
                                }
                            }
                        }
                    }
                    newForms.append(rowCell)
                }
            }else{
                
                do {
                    let value1 = item.price
                    let value2 = item.qty
                    let value3 = item.unit
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    let rowCell = TCFormCellModel<Cell_FinishOrderFeeNum>.init(data: (value1,value2,value3), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                        
                        if let thrQty = a as? Int {
                            var newItem = item
                            newItem.qty = thrQty.stringValue
                            newItem.amount = String(format: "%.2f", item.price.floatValue())
                            self?.model.userPayList[index] = newItem
                            self?.setUserAmount()
                            self?.makeForms()
                        }
                    }
                    newForms.append(rowCell)
                }
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_FinishPartDelete>.init(data: ("",""), config: uiConfigModel, id: nil, frameh: 47) {[weak self] a in
                    guard let weakSelf = self else { return }
                    guard weakSelf.canEdit else {
                        return
                    }
                     weakSelf.model.userPayList.remove(at: index)
                     weakSelf.setUserAmount()
                     weakSelf.makeForms()
                }
                newForms.append(rowCell)
            }
            
        }
        
        //总计
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            uiConfigModel.canEdit(self.canEdit)
            let payAmount = model.userPayAmount.doubleValue() - model.userPayDiscount.doubleValue()
            let rowCell = TCFormCellModel<Cell_FinishOrderFeeTotal>.init(data: (model.userPayAmount,model.userPayDiscount,payAmount.stringValue), config: uiConfigModel, id: nil, frameh: 120) {[weak self] (callValue) in
                guard let weakSelf = self else { return }
                guard weakSelf.canEdit else {
                    return
                }
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        weakSelf.model.userPayDiscount = cValue.1
                       
                    }else if cValue.0 == .editingDidEnd  {
                        weakSelf.makeForms()
                    }
                }
               
            }
            newForms.append(rowCell)
        }
        
        //验证码核验
//        if model.userPayAmount.floatValue() > 0 && model.userFeeVerification == "1"{
        
        //2024.01.20 userFeeVerification”=2且工单状态stat<=20
        if model.orderStat.intValue() <= 20 && model.userFeeVerification == "2"{
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let value = model.userFeeVerificationValue
                let rowCell = TCFormCellModel<Cell_FinishOrderFeeCode>.init(data: (model.userMobile,value,"请输入".languageString()), config: uiConfigModel, id: nil, frameh: 100, callBack: { [weak self] callValue in
                    if let cValue = callValue as? (UIControl.Event, String) {
                        if cValue.0 == .editingChanged  {
                            self?.model.userFeeVerificationValue = cValue.1
                        }else if cValue.0 == .editingDidEnd  {
                            self?.makeForms()
                        }
                    }
                    
                    if let actionStr = callValue as? String{
                        self?.getCodeCallback?("获取验证码")
                    }
                })
                
                newForms.append(rowCell)
            }
        }
        
        //备注模块
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            uiConfigModel.canEdit(canEdit)
            let rowCell = TCFormCellModel<Cell_FinishOrderFeeRemark>.init(data: (self.model.userPayRemark,"申请理由".languageString()), config: uiConfigModel, id: nil, frameh: 120) {  [weak self] callValue in
                guard let weakSelf = self else { return }
                guard weakSelf.canEdit else {
                    return
                }
                if let value = callValue as? (UIControl.Event,String) {
                    weakSelf.model.userPayRemark = value.1
                }
                
                if let value = callValue as? String {
                    weakSelf.model.userPayRemark = value
                    weakSelf.makeForms()
                }
            }
            newForms.append(rowCell)
        }
        
        
        //图片模块
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let pic1 = kGetServerPicUrl(model.userPayPic1)
            let pic2 = kGetServerPicUrl(model.userPayPic2)
            let pic3 = kGetServerPicUrl(model.userPayPic3)
            
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishOrderFeeImages>.init(data: (pic1,pic2,pic3), config: uiConfigModel, id: nil, frameh: 144) {[weak self] (a) in
                guard let weakSelf = self else { return }
                guard weakSelf.canEdit else {
                    return
                }
                if let theTag = a as? Int {
                    self?.imageCallback?(true,theTag)
                }
               
            }
            newForms.append(rowCell)
        }
        
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
    
    
    
    func setUserAmount() {
        var amount:CGFloat = 0
        amount = model.userPayList.map{($0.price.floatValue() * $0.qty.floatValue())}.reduce(0, +)
        self.model.userPayAmount = String(format: "%.2f", amount)
        self.makeForms()
    }
    
//    func setCompanyAmount() {
//        var amount:CGFloat = 0
//        amount = model.specailFeeList.map{($0.amount.floatValue())}.reduce(0, +)
//        self.model.sp = String(format: "%.2f", amount)
//        self.makeForms()
//    }
}
