//
//  FinishOrdeInfoVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/4.
//

import UIKit

class FinishOrdeInfoVm: NSObject {

    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var model = M_FinishOrder(json: [:])
    var disSelectCallback:(([String:Any])->())?
    var selectImageCallback:((Int,Int)->())?
    var selectCodeCallback:((String,Int,String)->())?
    var scanPartCodeCallback:((String,Int,String)->())?
    var finishState = 1
    var canEdit = true
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []
        newForms += makeFinishStateForms()
        newForms += makeInfoForms()
        newForms += makeItemForms()
        newForms += makeFaultForms()
        newForms += makePartsForms()
        
        forms = newForms
        callback?()
    }
    
    func makeFinishStateForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("完工状态".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishState>.init(data: (model.finishStatus.stringValue), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                guard let weakSelf = self else { return }
                guard weakSelf.canEdit else {
                    return
                }
                if let type = a as? Int {
                    weakSelf.model.finishStatus = type
                    weakSelf.makeForms()
                }
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("基本信息".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("服务类型".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(false)
                .showLine(true)
                .textAlignment(.right)
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, model.serviceTypeName, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setCellColor(UIColor(hexString: "f8f8f8"))
                .bgColor(UIColor(hexString: "ffffff"))
            let rowCell = TCFormCellModel<Cell_FinishSwitch>.init(data: ("保修类型".languageString(),model.guaranteeType,["保内".languageString(),"保外".languageString(),"类型不详".languageString()],[1,2,3]), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                guard let weakSelf = self else { return }
                guard weakSelf.canEdit else {
                    return
                }
                //保外不允许切换
                guard weakSelf.model.oldGuaranteeType != 2 else {
                    return
                }
                
                if let type = a as? Int {
                    //保内允许切保外
                    if weakSelf.model.oldGuaranteeType == 1 && type == 3{
                        return
                    }
                   //其他情况都可以切换
                    weakSelf.model.guaranteeType = type
                    
                    //机型的保修类型联动
                    if weakSelf.model.items.count > 0{
                        weakSelf.model.items[0].guaranteeType = type.stringValue
                    }
                    
                    self?.makeForms()
                }
            }
            newForms.append(rowCell)
        }
        
        if model.guaranteeType == 2 {
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setCellColor(UIColor(hexString: "f8f8f8"))
                    .bgColor(UIColor(hexString: "ffffff"))
                let rowCell = TCFormCellModel<Cell_FinishSwitch>.init(data: ("申请保外转保内".languageString(),model.outTransIn,["否".languageString(),"是".languageString(),""],[0,1,2]), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                    guard let weakSelf = self else { return }
                    guard weakSelf.canEdit else {
                        return
                    }
                    if let type = a as? Int {
                        weakSelf.model.outTransIn = type
                        weakSelf.makeForms()
                    }
                }
                newForms.append(rowCell)
            }
            
        }
        
        //固定新增字段
        if model.hasChannelName{
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title("购买渠道".languageString())
                    .titleFont(UIFont.systemFont(ofSize: 14))
                    .titleColor(UIColor(hexString: "666666"))
                    .infoFont(UIFont.systemFont(ofSize: 14))
                    .infoColor(UIColor(hexString: "333333"))
                    .showNext(true)
                    .showLine(true)
                    .textAlignment(.right)
                
                
                let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, model.buyChannelName, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                    guard let weakSelf = self else { return }
                    guard weakSelf.canEdit else {
                        return
                    }
                    let vc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "CreatOrderBaseDataVc") as! CreatOrderBaseDataVc
                    vc.title = "购买渠道".languageString()
                    vc.getDataUrl = "app/v2/basicInformation/getBuyChannel"
                    vc.vm.itemKey = "buyChannelName"
                    vc.listKey = "buyChannelList"
                    vc.selCallback = { (selItem) in
                        weakSelf.model.buyChannelId = selItem.stringValue(forKey: "buyChannelId")
                        weakSelf.model.buyChannelName = selItem.stringValue(forKey: "buyChannelName")
                        weakSelf.makeForms()
                    }
                    CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
                    
                })
                newForms.append(rowCell)
            }
        }
        
        if model.hasSafeEnvironmen{
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setCellColor(UIColor(hexString: "f8f8f8"))
                    .bgColor(UIColor(hexString: "ffffff"))
                let rowCell = TCFormCellModel<Cell_FinishSwitch>.init(data: ("安装环境是否符合".languageString(),model.isSafeEnvironment,["是".languageString(),"否".languageString(),""],[1,0,2]), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                    guard let weakSelf = self else { return }
                    guard weakSelf.canEdit else {
                        return
                    }
                    if let type = a as? Int {
                        weakSelf.model.isSafeEnvironment = type
                        weakSelf.makeForms()
                    }
                }
                newForms.append(rowCell)
            }
        }
        
        if model.hasPolicy{
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setCellColor(UIColor(hexString: "f8f8f8"))
                    .bgColor(UIColor(hexString: "ffffff"))
                let rowCell = TCFormCellModel<Cell_FinishSwitch>.init(data: ("是否政策".languageString(),model.isPolicy,["是".languageString(),"否".languageString(),""],[1,0,2]), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                    guard let weakSelf = self else { return }
                    guard weakSelf.canEdit else {
                        return
                    }
                    if let type = a as? Int {
                        weakSelf.model.isPolicy = type
                        weakSelf.makeForms()
                    }
                }
                newForms.append(rowCell)
            }
        }
        
        if model.hasVirtuallyUserMobile {
            do {
                let placeholderText = !canEdit ? "" : "请输入".languageString()
                
                let cfModel = TCFormCellConfigModel(titleStr: "用户号码".languageString()).showTip(false).setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                    .infoColor(UIColor(hexString: "#333333"))
                    .infoFont(UIFont.systemFont(ofSize: 14))
                    .bgColor(UIColor.white)
                    .setCellColor(UIColor(hexString: "f8f8f8"))
                    .titleColor(UIColor.init(hexString: "999999"))
                    .textAlignment(.right)
                    .showLine(false)
                    .canEdit(canEdit)
                    .unitText(placeholderText)
                
                let rowCell = TCFormCellModel<Cell_FinishOrderFeeInput>.init(data: (80, model.virtuallyUserMobile, placeholderText, nil, nil), config: cfModel, id: nil, frameh: 40, callBack: { [weak self] callValue in
                    guard let weakSelf = self else { return }
                    guard weakSelf.canEdit else {
                        return
                    }
                    if let cValue = callValue as? (UIControl.Event, String) {
                        if cValue.0 == .editingChanged  {
                            self?.model.virtuallyUserMobile = cValue.1
                        }else if cValue.0 == .editingDidEnd  {
                            self?.makeForms()
                        }
                    }
                }, didSelect: nil)
                newForms.append(rowCell)
            }
        }
        
        //自定义字段
        for (index,item) in model.showFields.enumerated() {
            
            //fieldType", 值类型:1文本框;2下拉选择框;3单选框)
            if item.fieldType == "3"{
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel().setCellColor(UIColor(hexString: "f8f8f8"))
                        .bgColor(UIColor(hexString: "ffffff"))
                    
                    let selNames = item.fieldValueList.compactMap { vs in
                        vs.stringForKey("value")
                    }
                    let selValues = item.fieldValueList.compactMap { vs in
                        vs.intValue(forKey:"key")
                    }
                    
                    let rowCell = TCFormCellModel<Cell_FinishSwitch>.init(data: (item.fieldName,item.fieldValue.intValue(),selNames,selValues), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                        guard let weakSelf = self else { return }
                        guard weakSelf.canEdit else {
                            return
                        }
                        if let type = a as? Int {
                            var newIetem = item
                            newIetem.fieldValue = type.stringValue
                            weakSelf.model.showFields[index] = newIetem
                            weakSelf.makeForms()
                        }
                    }
                    newForms.append(rowCell)
                }
            }else if item.fieldType == "2"{
                //下拉框选择
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                        .title(item.fieldName)
                        .titleFont(UIFont.systemFont(ofSize: 14))
                        .titleColor(UIColor(hexString: "666666"))
                        .infoFont(UIFont.systemFont(ofSize: 14))
                        .infoColor(UIColor(hexString: "333333"))
                        .showNext(true)
//                        .showTip(item.isMust == "1")
                        .showLine(true)
                        .textAlignment(.right)
                    
                    let selNames = item.fieldValueList.compactMap { vs in
                        vs.stringForKey("value")
                    }
                    let selValues = item.fieldValueList.compactMap { vs in
                        vs.stringForKey("key")
                    }
                    let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, item.fieldValue, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                        
                        let pickerDataArr = item.fieldValueList.compactMap {
                            ($0.stringValue(forKey: "value"),"")
                        }
                        TWSheetPicker.showActionSheet(titleStr: "请选择".languageString(), singleType: true, dataArr: pickerDataArr) {  [weak self] (indexArr) in
                            guard let weakSelf = self else { return }
                            guard weakSelf.canEdit else {
                                return
                            }
                            guard let sel_index = indexArr.first else { return }
                            let curSelValue = selValues[sel_index]
                            let curSelName = selNames[sel_index]
                          
                            var newIetem = item
                            newIetem.fieldValue = curSelName
                            newIetem.fieldKey = curSelValue
                            weakSelf.model.showFields[index] = newIetem
                            weakSelf.makeForms()
                          
                        }.show(CD.visibleVC!)
                    })
                    newForms.append(rowCell)
                }
            }else{
                //文本
                do {
                    let placeholderText = !canEdit ? "" : "请输入".languageString()
                    
                    let cfModel = TCFormCellConfigModel(titleStr: item.fieldName).showTip(item.isMust == "1").setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                        .infoColor(UIColor(hexString: "#333333"))
                        .infoFont(UIFont.systemFont(ofSize: 14))
                        .bgColor(UIColor.white)
                        .setCellColor(UIColor(hexString: "f8f8f8"))
                        .titleColor(UIColor.init(hexString: "999999"))
                        .textAlignment(.right)
                        .showLine(false)
                        .canEdit(canEdit)
                        .unitText(placeholderText)
                    
                    let rowCell = TCFormCellModel<Cell_FinishOrderFeeInput>.init(data: (80, item.fieldValue, placeholderText, nil, nil), config: cfModel, id: nil, frameh: 40, callBack: { [weak self] callValue in
                        guard let weakSelf = self else { return }
                        guard weakSelf.canEdit else {
                            return
                        }
                        if let cValue = callValue as? (UIControl.Event, String) {
                            if cValue.0 == .editingChanged  {
                                var newItem = item
                                newItem.fieldValue = cValue.1
                                self?.model.showFields[index] = newItem
                               
                            }else if cValue.0 == .editingDidEnd  {
                                self?.makeForms()
                            }
                        }
                    }, didSelect: nil)
                    newForms.append(rowCell)
                }
            }
            
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("完工备注".languageString())
                .titleColor(UIColor(hexString: "666666"))
                .titleFont(UIFont.systemFont(ofSize: 14))
                .canEdit(canEdit)
                .showLine(false)
            
            let placeholder = canEdit ? "请输入".languageString() : ""
            let rowCell = TCFormCellModel<TCTextViewCell>.init(data: (model.finishNote, placeholder, ""), config: uiConfigModel, id: nil, frameh: 150) { [weak self] callValue in
                
                if let value = callValue as? (UIControl.Event,String) {
                    self?.model.finishNote = value.1
                }
                
                if let value = callValue as? String {
                    self?.model.finishNote = value
                    self?.makeForms()
                }
            }
            newForms.append(rowCell)
        }
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
    
    func makeItemForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        
        guard model.items.count > 0 else {
            return []
        }
        
        for (index,item) in model.items.enumerated() {
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
                newForms.append(rowCell)
            }
            
            //header
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("产品信息".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
                }
                newForms.append(rowCell)
            }
            
            //分类
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title("产品分类".languageString())
                    .titleFont(UIFont.systemFont(ofSize: 14))
                    .titleColor(UIColor(hexString: "666666"))
                    .infoFont(UIFont.systemFont(ofSize: 14))
                    .infoColor(UIColor(hexString: "333333"))
                    .showNext(false)
                    .showLine(true)
                    .textAlignment(.right)
                
                var smallitemcatname = ""
                if smallitemcatname != "" {
                    smallitemcatname = "/"+item.smallitemcatname
                }
                let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, item.bigitemcatname+smallitemcatname, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                })
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title("产品型号".languageString())
                    .titleFont(UIFont.systemFont(ofSize: 14))
                    .titleColor(UIColor(hexString: "666666"))
                    .infoFont(UIFont.systemFont(ofSize: 14))
                    .infoColor(UIColor(hexString: "333333"))
                    .showNext(true)
                    .showLine(true)
                    .textAlignment(.right)
                let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, item.itemname, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                    guard let weakSelf = self else { return }
                    guard weakSelf.canEdit else {
                        return
                    }
                    let vc = UIStoryboard(name: "FinishOrder", bundle: nil).instantiateViewController(withIdentifier: "FinishOrderItemVc") as! FinishOrderItemVc
                    vc.title = "产品型号".languageString()
                    vc.isShowHeader = true
                    vc.loadMore = true
                    vc.getDataUrl = "app/v2/orderFinishDo/searchItem"
                    
                    var itemCategoryId = item.bigitemcatid
                    if item.smallitemcatid != "" {
                        itemCategoryId = item.smallitemcatname
                    }
                    vc.subJoinParam = ["orderId":weakSelf.model.orderId,"itemCategoryId":itemCategoryId]
                    vc.parentId = item.bigitemcatid
            
                    vc.didSelCallback = { (selItem) in
                        var newItem = item
                        newItem.itemid = selItem.itemId
                        newItem.itemname = selItem.itemName
                        newItem.itemcode = selItem.itemCode
                        newItem.entId = ""
                        weakSelf.model.items[index] = newItem
                        
                        if index == 0 {
                            let itemId = weakSelf.model.itemid
                            let new_itemId = selItem.itemId
                            
                            if new_itemId != "" && new_itemId != "0"{
                                weakSelf.model.itemid = new_itemId
                            }
                            
                            if new_itemId != itemId {
                                //清空配件
                                weakSelf.model.partsList.removeAll()
                            }
                            
                        }
                        weakSelf.makeForms()
                    }
                    CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
                })
                newForms.append(rowCell)
            }
            
            if item.hasInCode  == true{
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    let rowCell = TCFormCellModel<Cell_FinishCodeHeader>.init(data: ("机身条码".languageString(),"点击识别产品及保修期".languageString()), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                        //识别请求
                        guard let weakSelf = self else { return }
                        guard weakSelf.canEdit else {
                            return
                        }
                        self?.selectCodeCallback?(item.inbarcode,index,item.buyDate)
                    }
                    newForms.append(rowCell)
                }
            }
            
            let placeholder = canEdit ? "请输入".languageString() : ""
            
            
            //code 1
            if item.hasInCode  == true{
                do {
                    let cfModel = TCFormCellConfigModel(titleStr: "条码1".languageString())
                        .canEdit(canEdit)
                    let rowCell = TCFormCellModel<Cell_FinishOrderItemCode>.init(data: (item.inbarcode, "条码1".languageString(),placeholder), config: cfModel, id: nil, frameh: 52, callBack: { [weak self] callValue in
                        if let cValue = callValue as? (UIControl.Event, String) {
                            if cValue.0 == .editingChanged  {
                                var newItem = item
                                newItem.inbarcode = cValue.1
                                if index == 0 {
                                    self?.model.code1 = cValue.1
                                }
                                self?.model.items[index] = newItem
                            }else if cValue.0 == .editingDidEnd  {
                                self?.makeForms()
                                //输入结束请求条码识别
                                let code = cValue.1
                                DispatchQueue.main.asyncAfter(deadline: .now() + 0.5) {
                                    self?.selectCodeCallback?(code,index,item.buyDate)
                                }
                               
                            }
                        }
                        if let actionStr = callValue as? String {
                            //扫码
                            guard self?.canEdit == true else {
                                return
                            }
                            let qrVC = QRViewController()
                            qrVC.configResultCall { code, errorStr in
                                if errorStr != "" {
                                    CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~".languageString())
                                    return
                                }
                                var newItem = item
                                newItem.inbarcode = code ?? ""
                                self?.model.items[index] = newItem
                                
                                if index == 0 {
                                    self?.model.code1 = code ?? ""
                                }
                                self?.makeForms()
                                
                                //识别条码
                                self?.selectCodeCallback?(newItem.inbarcode,index,item.buyDate)
                            }
                            let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
                            qrNavigationC.modalPresentationStyle = .overFullScreen
                            qrNavigationC.modalTransitionStyle = .crossDissolve
                            CD.visibleVC?.present(qrNavigationC, animated: true, completion: nil)
                        }
                    }, didSelect: nil)
                    newForms.append(rowCell)
                }
            }
            
            //code 2
            if item.hasOutCode == true{
                do {
                    let cfModel = TCFormCellConfigModel(titleStr: "条码2".languageString())
                        .canEdit(canEdit)
                    let rowCell = TCFormCellModel<Cell_FinishOrderItemCode>.init(data: (item.outbarcode, "条码2".languageString(),placeholder), config: cfModel, id: nil, frameh: 52, callBack: { [weak self] callValue in
                        if let cValue = callValue as? (UIControl.Event, String) {
                            if cValue.0 == .editingChanged  {
                                var newItem = item
                                newItem.outbarcode = cValue.1
                                self?.model.items[index] = newItem
                            }else if cValue.0 == .editingDidEnd  {
                                self?.makeForms()
                            }
                        }
                        if let actionStr = callValue as? String {
                            //扫码
                            guard self?.canEdit == true else {
                                return
                            }
                            let qrVC = QRViewController()
                            qrVC.configResultCall { code, errorStr in
                                if errorStr != "" {
                                    CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~")
                                    return
                                }
                                var newItem = item
                                newItem.outbarcode = code ?? ""
                                self?.model.items[index] = newItem
                                self?.makeForms()
                            }
                            let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
                            qrNavigationC.modalPresentationStyle = .overFullScreen
                            qrNavigationC.modalTransitionStyle = .crossDissolve
                            CD.visibleVC?.present(qrNavigationC, animated: true, completion: nil)
                            
                        }
                    }, didSelect: nil)
                    newForms.append(rowCell)
                }
            }
            
            //code 3
            if item.hasBarCode3 == true{
                do {
                    let cfModel = TCFormCellConfigModel(titleStr: "条码3".languageString())
                        .canEdit(canEdit)
                    let rowCell = TCFormCellModel<Cell_FinishOrderItemCode>.init(data: (item.barCode3, "条码3".languageString(),placeholder), config: cfModel, id: nil, frameh: 52, callBack: { [weak self] callValue in
                        if let cValue = callValue as? (UIControl.Event, String) {
                            if cValue.0 == .editingChanged  {
                                var newItem = item
                                newItem.barCode3 = cValue.1
                                self?.model.items[index] = newItem
                            }else if cValue.0 == .editingDidEnd  {
                                self?.makeForms()
                            }
                        }
                        if let actionStr = callValue as? String {
                            //扫码
                            guard self?.canEdit == true else {
                                return
                            }
                            let qrVC = QRViewController()
                            qrVC.configResultCall { code, errorStr in
                                if errorStr != "" {
                                    CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~".languageString())
                                    return
                                }
                                var newItem = item
                                newItem.barCode3 = code ?? ""
                                self?.model.items[index] = newItem
                                self?.makeForms()
                            }
                            let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
                            qrNavigationC.modalPresentationStyle = .overFullScreen
                            qrNavigationC.modalTransitionStyle = .crossDissolve
                            CD.visibleVC?.present(qrNavigationC, animated: true, completion: nil)
                            
                        }
                    }, didSelect: nil)
                    newForms.append(rowCell)
                }
            }
    
            //IEMI
            if item.hasIemi {
                do {
                    let cfModel = TCFormCellConfigModel(titleStr: "IEMI")
                        .canEdit(canEdit)
                    let rowCell = TCFormCellModel<Cell_FinishOrderItemCode>.init(data: (item.iemi, "IEMI",placeholder), config: cfModel, id: nil, frameh: 52, callBack: { [weak self] callValue in
                        if let cValue = callValue as? (UIControl.Event, String) {
                            if cValue.0 == .editingChanged  {
                                var newItem = item
                                newItem.iemi = cValue.1
                                self?.model.items[index] = newItem
                            }else if cValue.0 == .editingDidEnd  {
                                self?.makeForms()
                            }
                        }
                        if let actionStr = callValue as? String {
                            //扫码
                            guard self?.canEdit == true else {
                                return
                            }
                            let qrVC = QRViewController()
                            qrVC.configResultCall { code, errorStr in
                                if errorStr != "" {
                                    CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~")
                                    return
                                }
                                var newItem = item
                                newItem.iemi = code ?? ""
                                self?.model.items[index] = newItem
                                self?.makeForms()
                            }
                            let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
                            qrNavigationC.modalPresentationStyle = .overFullScreen
                            qrNavigationC.modalTransitionStyle = .crossDissolve
                            CD.visibleVC?.present(qrNavigationC, animated: true, completion: nil)
                            
                        }
                    }, didSelect: nil)
                    newForms.append(rowCell)
                }
            }
            
            //条码信息 F8FAFF
            if item.hasItemEndDate {
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                        .bgColor(UIColor(hexString: "F6FDFC"))
                        .title("整机产品保修期".languageString())
                        .titleFont(UIFont.systemFont(ofSize: 14))
                        .titleColor(UIColor(hexString: "666666"))
                        .infoFont(UIFont.systemFont(ofSize: 14))
                        .infoColor(UIColor(hexString: "333333"))
                        .showNext(false)
                        .showLine(true)
                        .textAlignment(.right)
                    let placeholderText = !canEdit ? "" : "请选择".languageString()
                    let rowCell = TCFormCellModel<TCLabelCell>.init(data: (120, item.itemEndDate, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                        guard let weakSelf = self else { return }
                        guard weakSelf.canEdit else {
                            return
                        }
                        /*
                        TSDatePickerVC.showDatePicker(titleStr: "请选择日期", maxDate: nil, minDate: nil) { (selDate) in
                           
                            let format = DateFormatter()
                            format.dateFormat = "yyyy-MM-dd HH:mm:ss"
                            var newItem = item
                            newItem.itemEndDate = format.string(from: selDate)
                            self?.model.items[index] = newItem
                            self?.makeForms()
                        }.show(CD.visibleVC!)
                         */
                    })
                    newForms.append(rowCell)
                }
            }
            
            if item.hasPartsEndDate {
           
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                        .bgColor(UIColor(hexString: "F6FDFC"))
                        .title("关键零部件保修期".languageString())
                        .titleFont(UIFont.systemFont(ofSize: 14))
                        .titleColor(UIColor(hexString: "666666"))
                        .infoFont(UIFont.systemFont(ofSize: 14))
                        .infoColor(UIColor(hexString: "333333"))
                        .showNext(false)
                        .showLine(true)
                        .textAlignment(.right)
                    let placeholderText = !canEdit ? "" : "请选择".languageString()
                    let rowCell = TCFormCellModel<TCLabelCell>.init(data: (120, item.partsEndDate, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                        guard let weakSelf = self else { return }
                        guard weakSelf.canEdit else {
                            return
                        }
                        /*
                        TSDatePickerVC.showDatePicker(titleStr: "请选择日期", maxDate: nil, minDate: nil) { (selDate) in
                            
                            let format = DateFormatter()
                            format.dateFormat = "yyyy-MM-dd HH:mm:ss"
                            var newItem = item
                            newItem.partsEndDate = format.string(from: selDate)
                            self?.model.items[index] = newItem
                            self?.makeForms()
                        }.show(CD.visibleVC!)
                         */
                    })
                    newForms.append(rowCell)
                }
            }
            
            if item.hasInstallDate {
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                        .bgColor(UIColor(hexString: "F6FDFC"))
                        .title("产品安装出库时间".languageString())
                        .titleFont(UIFont.systemFont(ofSize: 14))
                        .titleColor(UIColor(hexString: "666666"))
                        .infoFont(UIFont.systemFont(ofSize: 14))
                        .infoColor(UIColor(hexString: "333333"))
                        .showNext(false)
                        .showLine(true)
                        .textAlignment(.right)
                    let placeholderText = !canEdit ? "" : "请选择".languageString()
                    let rowCell = TCFormCellModel<TCLabelCell>.init(data: (120, item.installDate, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                        guard let weakSelf = self else { return }
                        guard weakSelf.canEdit else {
                            return
                        }
                        /*
                        TSDatePickerVC.showDatePicker(titleStr: "请选择日期", maxDate: nil, minDate: nil) { (selDate) in
                    
                            let format = DateFormatter()
                            format.dateFormat = "yyyy-MM-dd HH:mm:ss"
                            var newItem = item
                            newItem.installDate = format.string(from: selDate)
                            self?.model.items[index] = newItem
                            self?.makeForms()
                        }.show(CD.visibleVC!)
                         */
                    })
                    newForms.append(rowCell)
                }
            }
            
            if item.hasGuaranteeType{
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel().setCellColor(UIColor(hexString: "f8f8f8"))
                        .bgColor(UIColor(hexString: "F6FDFC"))
                    let rowCell = TCFormCellModel<Cell_FinishSwitch>.init(data: ("扫码带出保修类型",item.guaranteeType.intValue(),["保内".languageString(),"保外".languageString(),"未知".languageString()],[1,2,3]), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                        guard let weakSelf = self else { return }
                        guard weakSelf.canEdit else {
                            return
                        }
//                        if let type = a as? Int {
//
//                            var newItem = item
//                            newItem.guaranteeType = type.stringValue
//                            self?.model.items[index] = newItem
//
//                            weakSelf.makeForms()
//                        }
                    }
                    newForms.append(rowCell)
                }
            }
            
            if item.hasBuyDate {
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                        .bgColor(UIColor(hexString: "F6FDFC"))
                        .title("整机产品购买时间".languageString())
                        .titleFont(UIFont.systemFont(ofSize: 14))
                        .titleColor(UIColor(hexString: "666666"))
                        .infoFont(UIFont.systemFont(ofSize: 14))
                        .infoColor(UIColor(hexString: "333333"))
                        .showNext(true)
                        .showLine(true)
                        .textAlignment(.right)
                    let placeholderText = !canEdit ? "" : "请选择".languageString()
                    let rowCell = TCFormCellModel<TCLabelCell>.init(data: (120, item.buyDate, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                    
                        guard let weakSelf = self else { return }
                        guard weakSelf.canEdit else {
                            return
                        }
                        
                        TSDatePickerVC.showDatePicker(titleStr: "请选择日期".languageString(), maxDate: Date(), minDate: nil) { (selDate) in
                            
                            let format = DateFormatter()
                            format.dateFormat = "yyyy-MM-dd HH:mm:ss"
                            var newItem = item
                            newItem.buyDate = format.string(from: selDate)
                            self?.model.items[index] = newItem
                            self?.makeForms()
                        }.show(CD.visibleVC!)
                        
                    })
                    newForms.append(rowCell)
                }
            }
          
            //图片Cell_OrderFinishImages
            do {
                let cfModel = TCFormCellConfigModel(titleStr: "图片".languageString()).canEdit(self.canEdit)
                var height:CGFloat = 0
                let count = item.resultPicList.count
                if count > 0 {
                    //需要几行 n%2 = 0 n/2行   n%2 = 1 n/2+1
                    var n = 0
                    if count % 2 == 0 {
                        n = count/4
                    }
                    if count % 4 == 2 {
                        n = (count/4)+1
                    }
                    if count % 2 == 1 {
                        n = (count/4)+1
                    }
                    height = CGFloat(n) * 125
                }
                
                let rowCell = TCFormCellModel<Cell_OrderFinishImages>.init(data: (item.resultPicList), config: cfModel, id: nil, frameh: height, callBack: { [weak self] callValue in
                    
                    guard let weakSelf = self else { return }
                    
                    if let actionArr = callValue as? (String,Int) {
                        guard weakSelf.canEdit else {
                            return
                        }
                        debugPrint("点击了第n个")
                       let actionFlag = actionArr.0
                       let actionIndex = actionArr.1
                        
                        if actionFlag == "add"{
                            weakSelf.selectImageCallback?(index,actionIndex)
                        }
                        
                        if actionFlag == "delete"{
                            weakSelf.model.items[index].resultPicList[actionIndex].pic = ""
                            weakSelf.makeForms()
                        }
                    
                    }
                    
                    if let imageUrl = callValue as? String {
                        //查看大图
                        let picUrl = kGetServerPicUrl(imageUrl)
                        var picList = [String]()
                        picList.append(picUrl)
                        let photos = picList.compactMap({ (item) -> GKPhoto in
                            let photo = GKPhoto()
                            guard let imageUrl = URL(string: item) else {
                                return photo
                            }
                            photo.url = imageUrl
                            return photo
                        })
                        
                        let index = 0
                        
                        let browser = GKPhotoBrowser(photos: photos, currentIndex: index)
                        browser.showStyle = .none
                        browser.modalPresentationStyle = .overFullScreen
                        browser.show(fromVC: CD.visibleVC!)
                    }
                }, didSelect: nil)
                newForms.append(rowCell)
            }
      
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
        }
      
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.white)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        return newForms
    }
    
    //故障
    func makeFaultForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        
        guard model.companymanyfault != 0 else {
            return []
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let actionName = canEdit ? "新增故障".languageString() : ""
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("故障解决".languageString(),actionName), config: uiConfigModel, id: nil, frameh: 40) { [weak self] (a) in
                guard let weakSelf = self else { return }
                guard weakSelf.canEdit else {
                    return
                }
                weakSelf.model.faultList.append(M_FinishOrder.M_Fault(json: [:]))
                weakSelf.makeForms()
            }
            newForms.append(rowCell)
        }
        
        for (index,item) in model.faultList.enumerated() {
        
            if index != 0{
                //内容
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                        .bgColor(.clear)
                        .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                        .cornerRadius(8)
                    let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                    newForms.append(rowCell)
                }
                
                
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                        .bgColor(.clear)
                        .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                        .cornerRadius(8)
                    let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
                    newForms.append(rowCell)
                }
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title("故障现象".languageString())
                    .titleFont(UIFont.systemFont(ofSize: 14))
                    .titleColor(UIColor(hexString: "666666"))
                    .infoFont(UIFont.systemFont(ofSize: 14))
                    .infoColor(UIColor(hexString: "333333"))
                    .showNext(true)
                    .showLine(true)
                    .textAlignment(.right)
                let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, item.symptomName, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                    
                    guard let weakSelf = self else { return }
                    guard weakSelf.canEdit else {
                        return
                    }
                    let vc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "CreatOrderBaseDataVc") as! CreatOrderBaseDataVc
                    vc.title = "故障现象".languageString()
                    vc.loadMore = true
                    vc.isShowHeader = true
                    vc.getDataUrl = "app/v2/orderFinishDo/searchFaultSysmtom"
                    vc.vm.itemKey = "symptomName"
                    vc.subJoinParam = ["itemCategoryId":weakSelf.model.itemCategoryId,"orderId":weakSelf.model.orderId]
                    vc.listKey = "dataList"
                    vc.selCallback = { (selItem) in
                        var newFault = item
                        newFault.sysmtomId = selItem.stringForKey("sysmtomId")
                        newFault.symptomName = selItem.stringForKey("symptomName")
                        weakSelf.model.faultList[index] = newFault
                        weakSelf.makeForms()
                    }
                    CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
                })
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title("故障原因".languageString())
                    .titleFont(UIFont.systemFont(ofSize: 14))
                    .titleColor(UIColor(hexString: "666666"))
                    .infoFont(UIFont.systemFont(ofSize: 14))
                    .infoColor(UIColor(hexString: "333333"))
                    .showNext(true)
                    .showLine(true)
                    .textAlignment(.right)
                let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, item.reasonName, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                    
                    guard let weakSelf = self else { return }
                    guard weakSelf.canEdit else {
                        return
                    }
                    
                    guard item.sysmtomId != "" else {
                        hud_error("请选择".languageString()+"故障现象".languageString())
                        return
                    }
                    let vc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "CreatOrderBaseDataVc") as! CreatOrderBaseDataVc
                    vc.title = "故障原因".languageString()
                    vc.loadMore = true
                    vc.isShowHeader = true
                    vc.getDataUrl = "app/v2/orderFinishDo/searchFaultReason"
                    vc.vm.itemKey = "reasonName"
                    vc.subJoinParam = ["itemCategoryId":weakSelf.model.itemCategoryId,"sysmtomId":item.sysmtomId]
                    vc.listKey = "dataList"
                    vc.selCallback = { (selItem) in
                        var newFault = item
                        newFault.reasonId = selItem.stringForKey("reasonId")
                        newFault.reasonName = selItem.stringForKey("reasonName")
                        weakSelf.model.faultList[index] = newFault
                        weakSelf.makeForms()
                    }
                    CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
                })
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title("维修措施".languageString())
                    .titleFont(UIFont.systemFont(ofSize: 14))
                    .titleColor(UIColor(hexString: "666666"))
                    .infoFont(UIFont.systemFont(ofSize: 14))
                    .infoColor(UIColor(hexString: "333333"))
                    .showNext(true)
                    .showLine(index != 0)
                    .textAlignment(.right)
                let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, item.methodName, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                    
                    guard let weakSelf = self else { return }
                    guard weakSelf.canEdit else {
                        return
                    }
                    guard item.sysmtomId != "" else {
                        hud_error("请选择".languageString()+"故障现象".languageString())
                        return
                    }
                    guard item.reasonId != "" else {
                        hud_error("请选择".languageString()+"故障原因".languageString())
                        return
                    }
                    let vc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "CreatOrderBaseDataVc") as! CreatOrderBaseDataVc
                    vc.title = "维修措施".languageString()
                    vc.loadMore = true
                    vc.isShowHeader = true
                    vc.getDataUrl = "app/v2/orderFinishDo/searchFixMethod"
                    vc.vm.itemKey = "methodName"
                    vc.subJoinParam = ["itemCategoryId":weakSelf.model.itemCategoryId,"sysmtomId":item.sysmtomId,"reasonId":item.reasonId]
                    vc.listKey = "dataList"
                    vc.selCallback = { (selItem) in
                        var newFault = item
                        newFault.methodName = selItem.stringForKey("methodName")
                        newFault.method_id = selItem.stringForKey("methodId")
                        newFault.serviceTypeId = selItem.stringForKey("serviceTypeId")
                        newFault.serviceTypeName = selItem.stringForKey("serviceTypeName")
                        weakSelf.model.faultList[index] = newFault
                        weakSelf.makeForms()
                    }
                    CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
                })
                newForms.append(rowCell)
            }
            
            //删除按钮
            if canEdit {
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel().bgColor(UIColor(hexString: "ffffff")).setCellColor(UIColor(hexString: "f8f8f8"))
                    let rowCell = TCFormCellModel<Cell_FinishDeleteRow>.init(data: (false, "hep_icon_delete","删除".languageString(), UIColor(hexString: "#666666"), 60, .white), config: uiConfigModel, id: nil, frameh: 50) {[weak self] (a) in
                        //删除该条
                        guard let weakSelf = self else { return }
                        guard weakSelf.canEdit else {
                            return
                        }
                        if weakSelf.model.faultList.count == 1 {
                            hud_error("该服务类型至少要有一组故障信息~".languageString())
                            return
                        }
                        weakSelf.model.faultList.remove(at: index)
                        weakSelf.makeForms()
                    }
                    newForms.append(rowCell)
                }
            }
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
        }
        
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        

        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
       return newForms
    }
    
    
    func makePartsForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        
        guard self.model.hasParts else {
            return []
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let actionName = canEdit ? "选择配件".languageString() : ""
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("更换配件".languageString(),actionName), config: uiConfigModel, id: nil, frameh: 40) {[weak self] (a) in
                guard let weakSelf = self else { return }
                guard weakSelf.canEdit else {
                    return
                }
                let vc = UIStoryboard(name: "FinishOrder", bundle: nil).instantiateViewController(withIdentifier: "FinishOrderSelectPartVc") as! FinishOrderSelectPartVc
                vc.itemId = weakSelf.model.itemid
                vc.orderId = weakSelf.model.orderId
                vc.code1 = weakSelf.model.code1
                vc.searchType = "0"
                vc.didSelCallback = {(selItes) in
                    
                    var newItem = selItes
                    newItem.num = selItes.num
                    newItem.amount = selItes.userPrice
                    newItem.pic = selItes.partsPic
                    //默认一个旧件
                    newItem.oldPic = selItes.partsPic
                    newItem.oldPartsId = selItes.partsId
                    newItem.oldPartsName = selItes.partsName
                    newItem.oldPartsCode = selItes.partsCode
                    
                    //去重
                    //判断是否已有明细
                    var isExst = false
                    var exstIndex = 0
                    for (index,item) in weakSelf.model.partsList.enumerated() {
                        if item.partsId == newItem.partsId {
                            isExst = true
                            exstIndex = index
                        }
                    }
                    if !isExst {
                        weakSelf.model.partsList.append(newItem)
                        weakSelf.makeForms()
                    }else{
                        SVProgressHUD.showError(withStatus: "配件已存在~".languageString())
                    }
                }
                CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
            }
            newForms.append(rowCell)
        }
        
        for (index,item) in model.partsList.enumerated() {
            
            //=========旧件
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                uiConfigModel.bgColor(UIColor.init(hexString: "F8F8F8"))
                uiConfigModel.nextImageStr("tag_old_accessory")
                let picUrl = kGetServerPicUrl(item.oldPic)
                
                let rowCell = TCFormCellModel<Cell_FinishPartInfo>.init(data: (item.oldPartsName,item.oldPartsCode,picUrl), config: uiConfigModel, id: nil, frameh: 66) {[weak self] a in
                    //重选旧件xx
                    guard let weakSelf = self else { return }
                    guard weakSelf.canEdit else {
                        return
                    }
                    let vc = UIStoryboard(name: "FinishOrder", bundle: nil).instantiateViewController(withIdentifier: "FinishOrderSelectPartVc") as! FinishOrderSelectPartVc
                    vc.itemId = weakSelf.model.itemid
                    vc.orderId = weakSelf.model.orderId
                    vc.code1 = weakSelf.model.code1
                    vc.searchType = "1"
                    vc.isSelectedOld = true
                    vc.didSelCallback = {(selItes) in
                        
                        var newItem = item
                        //选择一个旧件
                        newItem.oldPic = selItes.partsPic
                        newItem.oldPartsId = selItes.partsId
                        newItem.oldPartsName = selItes.partsName
                        newItem.oldPartsCode = selItes.partsCode
                        
                        weakSelf.model.partsList[index] = newItem
                        weakSelf.makeForms()
                    }
                    
                    CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
                    
                }
                newForms.append(rowCell)
            }
            
            //扫码
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                uiConfigModel.bgColor(UIColor.init(hexString: "F8F8F8"))
                let rowCell = TCFormCellModel<Cell_FinishPartCode>.init(data: ("旧件扫码".languageString(),item.barcode2), config: uiConfigModel, id: nil, frameh: 66) {[weak self] actionStr in
                    if let theStr = actionStr as? String{
                        if theStr == "打开扫码"{
                            let qrVC = QRViewController()
                            qrVC.configResultCall { code, errorStr in
                                if errorStr != "" {
                                    CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~".languageString())
                                    return
                                }
                                //去匹配旧配件
                                self?.scanPartCodeCallback?(code ?? "",index,"旧件扫码")
                            }
                            let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
                            qrNavigationC.modalPresentationStyle = .overFullScreen
                            qrNavigationC.modalTransitionStyle = .crossDissolve
                            CD.visibleVC?.present(qrNavigationC, animated: true, completion: nil)
                        }
                        else{
                            if theStr == ""{return}
                            //去匹配旧配件
                            self?.scanPartCodeCallback?(theStr,index,"旧件扫码")
                        }
                    }
                }
                newForms.append(rowCell)
            }
            
            //=========新件
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                uiConfigModel.bgColor(UIColor.init(hexString: "F7F2EE"))
                uiConfigModel.nextImageStr("tag_new_accessory")
                let picUrl = kGetServerPicUrl(item.pic)
                
                let rowCell = TCFormCellModel<Cell_FinishPartInfo>.init(data: (item.partsName,item.partsCode,picUrl), config: uiConfigModel, id: nil, frameh: 66) { a in
                }
                newForms.append(rowCell)
            }
            
            //扫码
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                uiConfigModel.bgColor(UIColor.init(hexString: "F7F2EE"))
                let rowCell = TCFormCellModel<Cell_FinishPartCode>.init(data: ("新件扫码".languageString(),item.barcode), config: uiConfigModel, id: nil, frameh: 66) { [weak self] actionStr in
                    
                    if let theStr = actionStr as? String{
                        if theStr == "打开扫码"{
                            let qrVC = QRViewController()
                            qrVC.configResultCall { code, errorStr in
                                if errorStr != "" {
                                    CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~".languageString())
                                    return
                                }
                                //去匹配旧配件
                                self?.scanPartCodeCallback?(code ?? "",index,"新件扫码")
                            }
                            let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
                            qrNavigationC.modalPresentationStyle = .overFullScreen
                            qrNavigationC.modalTransitionStyle = .crossDissolve
                            CD.visibleVC?.present(qrNavigationC, animated: true, completion: nil)
                        }
                        else{
                            if theStr == ""{return}
                            //去匹配旧配件
                            self?.scanPartCodeCallback?(theStr,index,"新件扫码")
                        }
                    }
                }
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                uiConfigModel.canEdit(self.canEdit)
                
                let value1 = item.userPrice == "" ? "0.00" : item.userPrice
                let value2 = item.num == "" ? "0" : item.num
                let value3 = item.maxQty == "" ? "0" : item.maxQty
                let value4 = item.invQty == "" ? "0" : item.invQty
                
                let rowCell = TCFormCellModel<Cell_FinishPartNum>.init(data: (value1,value2,value3,value4), config: uiConfigModel, id: nil, frameh: 88) {[weak self] a in
                    
                    if let thrQty = a as? Int {
                        var newItem = item
                        newItem.num = thrQty.stringValue
                        self?.model.partsList[index] = newItem
                        self?.makeForms()
                    }
                }
                newForms.append(rowCell)
            }
            
            // 删除
            if canEdit {
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    let rowCell = TCFormCellModel<Cell_FinishPartDelete>.init(data: ("",""), config: uiConfigModel, id: nil, frameh: 47) { [weak self] a in
                        
                        //删除该条
                        guard let weakSelf = self else { return }
                        guard weakSelf.canEdit else {
                            return
                        }
                        weakSelf.model.partsList.remove(at: index)
                        weakSelf.makeForms()
                    }
                    newForms.append(rowCell)
                }
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
            

        
       return newForms
    }
}
