//
//  FinishOrderSelectPartVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/11.
//

import UIKit

class FinishOrderSelectPartVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var didSelCallback:((M_FinishOrder.M_Part)->())?
    var itemArr = [M_FinishOrder.M_Part]()
    var isSelectedOld = false
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []

        newForms += makeItemsForms()
        forms = newForms
        callback?()
    }
    
    func makeItemsForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        
        guard itemArr.count != 0 else {
            return []
        }
        
        for (index,item) in itemArr.enumerated() {
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
                newForms.append(rowCell)
            }
            
            // header
            do {
                let name = item.partsName
                let code = item.partsCode
                let pic = kGetServerPicUrl(item.partsPic) 
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                
                let rowCell = TCFormCellModel<Cell_FinishOrderSelectPartHeader>.init(data: (name,code,pic,item.selected), config: uiConfigModel, id: nil, frameh: 60) { a in
                    //选择
                    if item.num == "0" {
                        SVProgressHUD.showError(withStatus: "数量不能为0!".languageString())
                        return
                    }
                    var newItem = item
                    newItem.selected = !item.selected
                    self.itemArr[index] = newItem
                    self.makeForms()
                   
                    self.didSelCallback?(newItem)
                }
                newForms.append(rowCell)
            }
            
            do {
                let value1 = item.userPrice == "" ? "0.00" : item.userPrice
            
                var value2 = ""
                var value3 = ""
                var value4 = ""
                
                //旧件不用管库存和更换数量
                if isSelectedOld{
                    value2 = item.num == "" ? "1" : item.num
                    value3 = "10000"
                    value4 = "10000"
                }else{
                     value2 = item.num == "" ? "0" : item.num
                     value3 = item.maxQty == "" ? "0" : item.maxQty
                     value4 = item.invQty == "" ? "0" : item.invQty
                }
            
                
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_FinishOrderSelectPartNum>.init(data: (value1,value2,value3,value4), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                    
                    if let thrQty = a as? Int {
                        var newItem = item
                        newItem.num = thrQty.stringValue
                        self?.itemArr[index] = newItem
                        self?.makeForms()
                    }
                }
                newForms.append(rowCell)
            }
            
            do {
                let qty1 = item.invQty == "" ? "0" : item.invQty
                let qty2 = item.maxQty == "" ? "0" : item.maxQty
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_FinishOrderSelectPartBottom>.init(data: ("当前库存".languageString()+"："+qty1,"最大更换量".languageString()+"："+qty2), config: uiConfigModel, id: nil, frameh: 44) { a in
                }
                newForms.append(rowCell)
            }
            
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
        }
        
       return newForms
    }
    
}
