//
//  HomeModel.swift
//  Service
//
//  Created by Jan on 2023/7/17.
//  Copyright © 2023 yus. All rights reserved.
//

import UIKit

struct HomeModel {
  
    var appbarner1 = ""
    var appbarner2 = ""
    var appbarner3 = ""
  
    var unAcceptQty = "0"
    var unTakeEngineerQty = "0"
    var unTakeSiteQty = "0" //转派网点
    var unFinishQty = "0"
    var exceptionQty = "0"
    
    var inDealQty = "0"
    var unReadMessageQty = "0"
    
    //工单列表主页
    var todayQty = "0"
    var tomorrow1Qty = "0"
    var tomorrow2Qty = "0"
    var tomorrow3Qty = "0"
    var tomorrow4Qty = "0"
    var tomorrowQty = "0"
    var unBookQty = "0"
    var inChangeQty = "0"
    var unOnDoorQty = "0"
    var finishQty = "0"
    var waitPartsQty = "0"
    var yesterdayQty = "0"
    var inDeliveryFixQty = "0"
    var unComfirmEngineerFinishQty = "0"
    
    var orderLists = [HomeOrder]()
    var messages = [HomeMessage]()
    var dateList = [HomeDays]()
    var banners = [Carousel]()
  
    init(json:[String:Any],isFirstLoad:Bool = false) {
        appbarner1 = kGetServerPicUrl(json.stringValue(forKey: "companyAppBarner1URL"))
        appbarner2 = kGetServerPicUrl(json.stringValue(forKey: "companyAppBarner2URL"))
        appbarner3 = kGetServerPicUrl(json.stringValue(forKey: "companyAppBarner3URL"))
      
        inDealQty = json.stringValue(forKey: "inDealQty")
        unAcceptQty = json.stringValue(forKey: "unAcceptQty")
        unTakeEngineerQty = json.stringValue(forKey: "unTakeEngineerQty")
        unTakeSiteQty = json.stringValue(forKey: "unTakeSiteQty")
        unFinishQty = json.stringValue(forKey: "unFinishQty")
        exceptionQty = json.stringValue(forKey: "exceptionQty")
        
        unReadMessageQty = json.stringValue(forKey: "unReadMessageQty")
        
        if inDealQty=="" {inDealQty="0"}
        if unAcceptQty=="" {unAcceptQty="0"}
        if unTakeEngineerQty=="" {unTakeEngineerQty="0"}
        if unTakeSiteQty=="" {unTakeSiteQty="0"}
        
        if unFinishQty=="" {unFinishQty="0"}
        if exceptionQty=="" {exceptionQty="0"}
        
        //工单列表主页
        todayQty = json.stringValue(forKey: "todayQty")
        tomorrow1Qty = json.stringValue(forKey: "tomorrow1Qty")
        tomorrow2Qty = json.stringValue(forKey: "tomorrow2Qty")
        tomorrow3Qty = json.stringValue(forKey: "tomorrow3Qty")
        tomorrow4Qty = json.stringValue(forKey: "tomorrow4Qty")
        tomorrowQty = json.stringValue(forKey: "tomorrowQty")
        yesterdayQty = json.stringValue(forKey: "yesterdayQty")
        
        unBookQty = json.stringValue(forKey: "unBookQty")
        inChangeQty = json.stringValue(forKey: "inChangeQty")
        unOnDoorQty = json.stringValue(forKey: "unOnDoorQty")
        unBookQty = json.stringValue(forKey: "unBookQty")
        finishQty = json.stringValue(forKey: "finishQty")
        waitPartsQty = json.stringValue(forKey: "waitPartsQty")
        inDeliveryFixQty = json.stringValue(forKey: "inDeliveryFixQty")
        unComfirmEngineerFinishQty = json.stringValue(forKey: "unComfirmEngineerFinishQty")
        
        if todayQty=="" {todayQty="0"}
        if tomorrow1Qty=="" {tomorrow1Qty="0"}
        if tomorrow2Qty=="" {tomorrow2Qty="0"}
        if tomorrow3Qty=="" {tomorrow3Qty="0"}
        if tomorrow4Qty=="" {tomorrow4Qty="0"}
        if tomorrowQty=="" {tomorrowQty="0"}
        if unBookQty=="" {unBookQty="0"}
        if inChangeQty=="" {inChangeQty="0"}
        if unOnDoorQty=="" {unOnDoorQty="0"}
        if finishQty=="" {finishQty="0"}
        if waitPartsQty=="" {waitPartsQty="0"}
        if yesterdayQty=="" {yesterdayQty="0"}
        if inDeliveryFixQty=="" {inDeliveryFixQty="0"}
        if unComfirmEngineerFinishQty=="" {unComfirmEngineerFinishQty="0"}
        
         if let datas = json["unReadMessageList"] as? [String]{
             messages = datas.compactMap({ t in
                HomeMessage(text: t)
            })
        }
        
        if let datas = json["dateList"] as? [[String:Any]]{
            dateList = datas.compactMap({ t in
                HomeDays(json: t)
            })
        }
        
        if let datas = json["appcarouselpic"] as? [[String:Any]]{
            banners = datas.compactMap({ t in
                Carousel(json: t)
            })
        }
        
        if isFirstLoad {
            if let orders = json["orderList"] as? [[String:Any]]{
                orderLists = orders.compactMap({ t in
                    HomeOrder(json: t)
                })
            }
        }

    }
    
    //工单
    struct HomeOrder {
        var orderId = ""
        var orderNo = ""
        var serviceTypeName = ""
        var isUrgent = ""
        var timeOutLable = ""
        var timeOutLableVelue = ""
        
        var orderStat = ""
        
        var lat = ""
        var lnt = ""
        
        var orderStatName = ""
        var categoryName = ""
        var userAddress = ""
        var userName = ""
        var userMobile = ""
        var timeLable = ""
        
        init(json:[String:Any]) {
            orderId = json.stringValue(forKey: "orderId")
            orderNo = json.stringValue(forKey: "orderNo")
            serviceTypeName = json.stringValue(forKey: "serviceTypeName")
            isUrgent = json.stringValue(forKey: "isUrgent")
            timeOutLable = json.stringValue(forKey: "timeOutLable")
            timeOutLableVelue = json.stringValue(forKey: "timeOutLableVelue")
            
            orderStat = json.stringValue(forKey: "orderStat")
            lat = json.stringValue(forKey: "lat")
            lnt = json.stringValue(forKey: "lnt")
            orderStatName = json.stringValue(forKey: "orderStatName")
            categoryName = json.stringValue(forKey: "categoryName")
            userAddress = json.stringValue(forKey: "userAddress")
            userName = json.stringValue(forKey: "userName")
            userMobile = json.stringValue(forKey: "userMobile")
            timeLable = json.stringValue(forKey: "timeLable")
        }
    }
  
    //消息
    struct HomeMessage {
        var content = ""
        init(text:String) {
            content = text
        }
    }
    
    //days list
    struct HomeDays {
        var dayame = ""
        var orderqty = ""
        var date = "" //用日期查询
        var week_dayame = ""

        init(json:[String:Any]) {
            dayame = json.stringValue(forKey: "dayOfMonth")
            orderqty = json.stringValue(forKey: "qty")
            if orderqty == "0" || orderqty == "" {
                orderqty = "暂无".languageString()
            }else{
                orderqty = orderqty+"单".languageString()
            }
            date = json.stringValue(forKey: "date")
            week_dayame = json.stringValue(forKey: "dayOfWeek")
        }
    }
    
    //appcarouselpic list
    struct Carousel {
        var jumplink = ""
        var picname = ""
        var picurl = ""

        init(json:[String:Any]) {
            picurl = json.stringValue(forKey: "picurl")
            jumplink = json.stringValue(forKey: "jumplink")
            picname = json.stringValue(forKey: "picname")
        }
    }
}



