//
//  Cell_HomeMessage.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/23.
//

import UIKit

class Cell_HomeMessage: UITableViewCell {
    @IBOutlet weak var view_message1: UIView!
    @IBOutlet weak var lab_message1: UILabel!
    @IBOutlet weak var view_message2: UIView!
    @IBOutlet weak var lab_message2: UILabel!
    
    @IBOutlet weak var view_point1: UIView!
    @IBOutlet weak var view_point2: UIView!
    @IBOutlet weak var lab_newsCount: UILabel!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_HomeMessage: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (HomeModel)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
    
    }
    
    func row_update(dataSource data: (HomeModel)) {
        lab_newsCount.text = data.unReadMessageQty
        lab_newsCount.isHidden = data.unReadMessageQty == ""
        lab_newsCount.isHidden = data.unReadMessageQty == "0"
        
        lab_message1.isHidden = true
        lab_message2.isHidden = true
        view_point1.isHidden = true
        view_point2.isHidden = true
        
        for (index,item) in data.messages.enumerated() {
            switch index {
            case 0:
                lab_message1.text = item.content
                lab_message1.isHidden = false
                view_point1.isHidden = false
            case 1:
                lab_message2.text = item.content
                lab_message2.isHidden = false
                view_point2.isHidden = false
            default:
               break
            }
        }
    }
    
}

