//
//  Cell_HomeOrderAction.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/23.
//

import UIKit

class Cell_HomeOrderAction: UITableViewCell {
    @IBOutlet weak var curCollectionView: UICollectionView!
    var actionNameArr = [(String,Int)]()
    var callBack: TCRowCallBack?
    var selectIndex = 0
    override func awakeFromNib() {
        super.awakeFromNib()
//        self.curCollectionView.semanticContentAttribute = UISemanticContentAttribute.forceRightToLeft
        self.curCollectionView.backgroundColor = UIColor(hexString: "f8f8f8")
        self.backgroundColor = UIColor(hexString: "f8f8f8")
        self.curCollectionView.register(UINib(nibName: "Cell_HomeOrderActionItem", bundle: nil), forCellWithReuseIdentifier: "Cell_HomeOrderActionItem")
    }
    
    // 设置信息
    func setupDataInfo(model: HomeModel) {
        actionNameArr.removeAll()
    
        actionNameArr.append(("新单 "+model.unAcceptQty,1))
        if MyInfo.shareInstance().userRole != .Engineer {
            if MyInfo.shareInstance().userRole == .Site{
                actionNameArr.append(("待派工 "+model.unTakeEngineerQty,3))
            }else{
                actionNameArr.append(("待派工 "+model.unTakeSiteQty,3))
            }
        }
        actionNameArr.append(("处理中 "+model.inDealQty,20))
        actionNameArr.append(("异常单 "+model.exceptionQty,21))
        actionNameArr.append(("全部",0))
     
        curCollectionView.reloadData()
    }
    
}


extension Cell_HomeOrderAction: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (HomeModel)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (HomeModel)) {
        self.setupDataInfo(model: data)
    }
    
}


extension Cell_HomeOrderAction: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout {
    
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        return 1
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return actionNameArr.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "Cell_HomeOrderActionItem", for: indexPath) as! Cell_HomeOrderActionItem
        cell.titleLabel.text = actionNameArr[indexPath.row].0
       
        if indexPath.row == selectIndex {
            cell.titleLabel.backgroundColor = hexColor(hex: "1777FF")
            cell.titleLabel.textColor = .white
            cell.titleLabel.font = UIFont.boldSystemFont(ofSize: 14)
            cell.btn_icon.isHidden = false
        }else{
            cell.titleLabel.backgroundColor = hexColor(hex: "ffffff")
            cell.titleLabel.textColor = hexColor(hex: "333333")
            cell.titleLabel.font = UIFont.systemFont(ofSize: 14)
            cell.btn_icon.isHidden = true
        }
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        if indexPath.row == actionNameArr.count-1 {
            return CGSize(width: 55, height: 50)
        }
        let height:CGFloat = 50
        var width = 20 + actionNameArr[indexPath.row].0.getLabelWidth(h: 20, f: UIFont.systemFont(ofSize: 14))
        if width < 60 {
            width = 60
        }
        
        if width > 80 {
            width = 80
        }
        return CGSize(width: width, height: height)
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, insetForSectionAt section: Int) -> UIEdgeInsets {
        return UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0)
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumLineSpacingForSectionAt section: Int) -> CGFloat {
        return 0
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumInteritemSpacingForSectionAt section: Int) -> CGFloat {
        return 0
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if indexPath.row == actionNameArr.count-1{
            callBack?(0)
        }else{
            selectIndex = indexPath.row
            curCollectionView.reloadData()
            
            let searchType = actionNameArr[indexPath.row].1
            callBack?(searchType)
        }
      
    }
    
}
