//
//  Cell_HomeOrderListHeader.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/23.
//

import UIKit

class Cell_HomeOrderListHeader: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var btn_state: UIButton!
    @IBOutlet weak var lab_serviceType: UILabel!
    @IBOutlet weak var btn_isUrgent: UIButton!
    @IBOutlet weak var width_btn_isUrgent: NSLayoutConstraint!
    
    @IBOutlet weak var btn_isTimeout: UIButton!
    @IBOutlet weak var btn_Time: UIButton!
    
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        self.backgroundColor = UIColor(hexString: "f9f9f9")
      
        self.btn_Time.contentEdgeInsets = UIEdgeInsets(top: 0,left: 5, bottom: 0,right: 5);
        self.btn_isTimeout.contentEdgeInsets = UIEdgeInsets(top: 0,left: 5, bottom: 0,right: 5);
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_HomeOrderListHeader: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (HomeModel.HomeOrder)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (HomeModel.HomeOrder)) {
        lab_serviceType.text = data.serviceTypeName
        btn_isTimeout.setTitle(data.timeOutLable, for: .normal)
        btn_Time.setTitle(data.timeOutLableVelue, for: .normal)
        btn_state.setTitle(data.orderStatName, for: .normal)
        
        if data.isUrgent == "1"{
            width_btn_isUrgent.constant = 40
            btn_isUrgent.isHidden = false
        }else{
            width_btn_isUrgent.constant = 0
            btn_isUrgent.isHidden = true
        }
        
        btn_isTimeout.isHidden = data.timeOutLable == ""
        btn_Time.isHidden = data.timeOutLableVelue == ""
        
        if data.timeOutLable == "超时"{
            btn_isTimeout.backgroundColor = UIColor(hexString: "FF6300")
        }else{
            btn_isTimeout.backgroundColor = UIColor(hexString: "009DA1")
        }
    }
    
}
