//
//  Cell_HomeOrderListLine.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/23.
//

import UIKit

class Cell_HomeOrderListLine: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var view_icon: UIButton!
    @IBOutlet weak var btn_right: UIButton!
    @IBOutlet weak var lab_title: UILabel!
    
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        self.backgroundColor = UIColor(hexString: "f9f9f9")
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func rightAction(_ sender: UIButton) {
        callBack?(sender.tag)
    }
    
    
}


extension Cell_HomeOrderListLine: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (HomeModel.HomeOrder,Int)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (HomeModel.HomeOrder,Int)) {
        switch data.1 {
        case 1:
            view_icon.setImage(UIImage(named: "icon_home_user"), for: .normal)
            lab_title.text = data.0.userName+" " +  data.0.userMobile
            btn_right.setImage(UIImage(named: "detail_icon_phone"), for: .normal)
            btn_right.isHidden = false
        case 2:
            view_icon.setImage(UIImage(named: "icon_home_time"), for: .normal)
            lab_title.text = data.0.timeLable
            btn_right.isHidden = true
        default:
            break
        }
    }
    
}

