//
//  Cell_HomePageBanner.swift
//  Service
//
//  Created by Jan on 2023/7/17.
//  Copyright © 2023 yus. All rights reserved.
//

import UIKit
import SDCycleScrollView

class Cell_HomePageBanner: UITableViewCell {
    lazy var bannerView: SDCycleScrollView = {
        let theBannerView = SDCycleScrollView(frame:CGRect.init(x: 0, y: 0, width: SCREEN_W-30, height: 200))
        theBannerView.backgroundColor = UIColor(hexString: "f8f8f8")
        theBannerView.clickItemOperationBlock = { (index)  in
            
        }
        return theBannerView
    }()
    
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var view_banner: UIView!
    var callBack: TCRowCallBack?
    var banners = [String]()
    override func awakeFromNib() {
        super.awakeFromNib()
//        let image = UIImage(named: "home_mg_bg")
//        bgView.layer.contents = image?.cgImage
        
        bgView.backgroundColor = UIColor(hexString: "f9f9f9")
        view_banner.backgroundColor = UIColor(hexString: "f9f9f9")
        view_banner.addSubview(bannerView)
        bannerView.pageDotColor = UIColor(hexString: "#BBBBBB")
        bannerView.currentPageDotColor = UIColor(hexString: "#1777FF")
        bannerView.snp_makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
        }
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    // MARK: - cycleView
    func setWithArr(){
        if banners.count == 0{
            self.setNormal()
            return
        }
        
        if banners.count == 1{
            bannerView.autoScroll = false
        }
        bannerView.imageURLStringsGroup = banners
        bannerView.autoScrollTimeInterval = 6
        bannerView.bannerImageViewContentMode = .scaleToFill
        
        if banners.count>1{
            bannerView.autoScroll = true
        }else{
            bannerView.autoScroll = false
        }
    }
    
    func setNormal(){
        bannerView.localizationImageNamesGroup = ["bg"]
        bannerView.autoScrollTimeInterval = 4
        bannerView.backgroundColor = UIColor.white
//        bannerView.placeholderImage = UIImage(named: "bg")
        bannerView.bannerImageViewContentMode = .scaleToFill
        if bannerView.localizationImageNamesGroup.count>1{
            bannerView.autoScroll = true
        }else{
            bannerView.autoScroll = false
        }
    }
    
    // mark - SDCycleScrollViewDelegate
    func cycleScrollView(_ cycleScrollView: SDCycleScrollView!, didScrollTo index: Int) {
        
    }
    
    func cycleScrollView(_ cycleScrollView: SDCycleScrollView!, didSelectItemAt index: Int) {
        callBack?(index)
    }
    
}


extension Cell_HomePageBanner: TCCell_RowCellUpdateProtocol {

    typealias DataSource = ([String])
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
    
    }
    
    func row_update(dataSource data: ([String])) {
        banners = data
        self.setWithArr()
        
    }
    
}


