//
//  Cell_HomeOrderListHeader.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/28.
//

import UIKit

class Cell_OrderListHomeHeader: UITableViewCell {
    
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var curCollectionView: UICollectionView!
    var actionNameArr = [(String,String,Int)]()
    var callBack: TCRowCallBack?
    var selectIndex = 0
    override func awakeFromNib() {
        super.awakeFromNib()
        
        let image = UIImage(named: "home_order_bg_top")
        self.layer.contents = image?.cgImage
        self.curCollectionView.register(UINib(nibName: "Cell_OrderListHomeHeaderItem", bundle: nil), forCellWithReuseIdentifier: "Cell_OrderListHomeHeaderItem")
    }
    
    // 设置信息
    func setupDataInfo(model: HomeModel) {
        actionNameArr.removeAll()
    
        actionNameArr.append(("新单".languageString(),model.unAcceptQty,1))
        actionNameArr.append(("待预约".languageString(),model.unBookQty,2))
        if MyInfo.shareInstance().userRole == .Site{
            actionNameArr.append(("待派工".languageString(),model.unTakeEngineerQty,3))
        }else{
            actionNameArr.append(("待派工".languageString(),model.unTakeSiteQty,3))
        }
        actionNameArr.append(("待上门".languageString(),model.unOnDoorQty,4))
        actionNameArr.append(("待完工".languageString(),model.unFinishQty,5))
        actionNameArr.append(("待备件".languageString(),model.waitPartsQty,6))
        actionNameArr.append(("完工确认".languageString(),model.unComfirmEngineerFinishQty,7))

        actionNameArr.append(("送修中".languageString(),model.inDeliveryFixQty,8))
        actionNameArr.append(("退换中".languageString(),model.inChangeQty,9))
        actionNameArr.append(("已完成".languageString(),model.finishQty,10))
    
        curCollectionView.reloadData()
    }
    
}


extension Cell_OrderListHomeHeader: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (HomeModel)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (HomeModel)) {
        self.setupDataInfo(model: data)
    }
    
}


extension Cell_OrderListHomeHeader: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout {
    
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        return 1
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return actionNameArr.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "Cell_OrderListHomeHeaderItem", for: indexPath) as! Cell_OrderListHomeHeaderItem
        cell.lab_title.text = actionNameArr[indexPath.row].0
        cell.lab_num.text = actionNameArr[indexPath.row].1.stringValue
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        return CGSize(width: (SCREEN_W-30)/5, height: 85)
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, insetForSectionAt section: Int) -> UIEdgeInsets {
        return UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0)
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumLineSpacingForSectionAt section: Int) -> CGFloat {
        return 0
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumInteritemSpacingForSectionAt section: Int) -> CGFloat {
        return 0
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        selectIndex = indexPath.row
        curCollectionView.reloadData()
        
        let searchType = actionNameArr[indexPath.row].2
        callBack?(searchType)
      
    }
    
}

