//
//  HomeMessageVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/24.
//

import UIKit
import JXSegmentedView

class HomeMessageVc: UIViewController {
    var curVC:HomeMessageListVc?
    var currentIndex = 0
    
    lazy var headView: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var childVcView: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var segmentedView: JXSegmentedView = {
        let segmentedV = JXSegmentedView()
        segmentedV.delegate = self
        return segmentedV
    }()
    
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let segmentedDa = JXSegmentedTitleDataSource()
        segmentedDa.titles = ["工单通知".languageString(), "备件通知".languageString(),"结算通知".languageString(),"考核通知".languageString()]
        segmentedDa.isTitleColorGradientEnabled = true
        segmentedDa.titleNormalColor = UIColor(hexString: "#666666")
        segmentedDa.titleNormalFont = UIFont.PingFangRegular(size: 14)
        segmentedDa.titleSelectedColor = UIColor(hexString: "#333333")
        segmentedDa.titleSelectedFont = UIFont.PingFangMedium(size: 14)
        return segmentedDa
    }()
    
    lazy var indicator:JXSegmentedIndicatorLineView = {
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorColor = UIColor(hexString: "#478BFF")
        indicator.indicatorWidth = 40
        return indicator
    }()
    
    lazy var listContainerView = JXSegmentedListContainerView(dataSource: self)
    lazy var subControllerList = [JXSegmentedListContainerViewListDelegate]()
    
    
    lazy var topBar: CD_TopBar = {
        return CD_TopBar()
    }()
    
    var callback: ((Bool) -> ())? //返回刷新一下
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "消息".languageString()
        setNavigationBackButton()
        configUI()
    }
    
    func configUI() {
        self.cd.navigationBar(hidden: true)
        self.view.cd
            .add(topBar)
            .add(headView)
            .add(childVcView)
        
        topBar.delegate = self
        
        segmentedView.defaultSelectedIndex = currentIndex
        segmentedDataSource.reloadData(selectedIndex: currentIndex)
        segmentedView.indicators = [indicator]
        segmentedView.dataSource = segmentedDataSource
        
        topBar.snp.makeConstraints { (make) in
            make.left.top.right.equalToSuperview()
        }
        
        headView.snp.makeConstraints { (make) in
            make.top.equalTo(self.topBar.snp.bottom)
            make.left.right.equalToSuperview()
            make.height.equalTo(50)
        }
        
        headView.addSubview(segmentedView)
        segmentedView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(48)
        }
        childVcView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.top.equalTo(headView.snp.bottom)
        }
        segmentedView.listContainer = listContainerView
        childVcView.addSubview(listContainerView)
        listContainerView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
         }
        
        addSubViewControlls()
        setCurrentVC()
    }
    
    func addSubViewControlls() {
        var cSubC = [JXSegmentedListContainerViewListDelegate]()
        
        do {
            let curViewC = HomeMessageListVc()
            curViewC.state = 1
            cSubC.append(curViewC)
        }
        
        do {
            let curViewC = HomeMessageListVc()
            curViewC.state = 2
            cSubC.append(curViewC)
        }
        
        do {
            let curViewC = HomeMessageListVc()
            curViewC.state = 3
            cSubC.append(curViewC)
        }
        
        do {
            let curViewC = HomeMessageListVc()
            curViewC.state = 4
            cSubC.append(curViewC)
        }
        
        subControllerList = cSubC
    }
    
    func setCurrentVC() {
        let vc = subControllerList[segmentedView.selectedIndex] as! HomeMessageListVc
        curVC = vc
    }
    
    func setOrderMessageCurrentVC(_ index:Int){
        if !subControllerList.isEmpty {
            segmentedView.selectItemAt(index: index)
        }else{
            segmentedDataSource.reloadData(selectedIndex: index)
        }
    }
    
}

//请求
extension HomeMessageVc{
    func requstReadData(){
        var param = [String:Any]()
        param["messageId"] = "0"
        let cNet = TWOCNetwork(url: "/app/v2/index/messageRead",andParam: param)
        cNet.successCall = { [weak self] (result) in
            guard let weakSelf = self else { return }
            weakSelf.curVC?.tableView.mj_header?.beginRefreshing()//刷新当前vc
        }
        cNet.failCall = {(errorTag,errorStr) in
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
}

extension HomeMessageVc: JXSegmentedViewDelegate, JXSegmentedListContainerViewDataSource {
    
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        return subControllerList.count
    }
    
    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return subControllerList[index]
    }
    
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        let vc = subControllerList[index] as! HomeMessageListVc
        curVC = vc
        if vc.isViewLoaded {
            vc.tableView.mj_header?.beginRefreshing()
        }
    }
}


extension HomeMessageVc: CD_TopBarProtocol {
    func topBarCustom() {
        topBar.cd.background(.clear)
        topBar._title = "通知".languageString()
        topBar._colorTitle = Config.color.hex("3")
        topBar.bar_navigation.line.cd.isHidden(false)
        
        topBar._style = "11"
        topBar._rightItemsWidth1 = 80
        topBar.bar_navigation.item_right.btn_1.cd
            .text(CD_TopBar.Model.font_item)
            .text(Config.font.font(14))
            .text(Config.color.hex("6"))
            .text("全部已读".languageString())
    }
    
    func update(withTopBar item: CD_TopNavigationBar.Item) -> [CD_TopNavigationBarItem.Item.Style]? {
        switch item {
        case .leftItem1:
            let color:UIColor = Config.color.hex("6")
            let icon = CD_IconFont.tback_light(22)
            return [.title([(icon.text, icon.font, color, .normal), (icon.text, icon.font, Config.color.hex("6"), .highlighted), (icon.text, icon.font, Config.color.hex("6"), .selected)])]
        default:
            return nil
        }
    }
    
    func didSelect(withTopBar item: CD_TopNavigationBar.Item) {
        super_topBarClick(item)
        switch item {
        case .leftItem1:
            callback?(true)
            break
        case .rightItem1:
           debugPrint("全部已读")
            break
        default:
            break
        }
    }
}



