//
//  HomePagingListOrderCell.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/13.
//

import UIKit

class HomePagingListOrderCell: UITableViewCell {
    //header
    @IBOutlet weak var btn_state: UIButton!
    @IBOutlet weak var lab_serviceType: UILabel!
    @IBOutlet weak var btn_isUrgent: UIButton!
    @IBOutlet weak var width_btn_isUrgent: NSLayoutConstraint!
    //工单标识
    @IBOutlet weak var btn_isTimeout: UIButton!
    @IBOutlet weak var btn_Time: UIButton!
    //机型
    @IBOutlet weak var lab_item: UILabel!
    //地址
    @IBOutlet weak var lab_address: UILabel!
    //用户
    @IBOutlet weak var lab_userInfo: UILabel!
    //工单时间
    @IBOutlet weak var lab_orderInfo: UILabel!
    //底部按钮操作
    @IBOutlet weak var bottomView: UIView!
    @IBOutlet weak var btn_action: UIButton!
    
    var searchType = 1
    var didClickButtonCallback: ((String) -> ())? //点击工单按钮
    override func awakeFromNib() {
        super.awakeFromNib()
        let image = UIImage(named: "icon_blue_jianbian")
        bottomView.layer.contents = image?.cgImage
        
        self.btn_isUrgent.contentEdgeInsets = UIEdgeInsets(top: 0,left: 5, bottom: 0,right: 5);
        self.btn_isTimeout.contentEdgeInsets = UIEdgeInsets(top: 0,left: 5, bottom: 0,right: 5);
        self.btn_Time.contentEdgeInsets = UIEdgeInsets(top: 0,left: 5, bottom: 0,right: 5);
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func callPhoneAction(_ sender: UIButton) {
        didClickButtonCallback?("拨打电话")
    }
    
    @IBAction func locationAction(_ sender: UIButton) {
        didClickButtonCallback?("导航定位")
    }
    
    @IBAction func orderAction(_ sender: UIButton) {
        didClickButtonCallback?(sender.titleLabel?.text ?? "")
    }
    
    func setData(_ data:HomeModel.HomeOrder){
        //header
        lab_serviceType.text = data.serviceTypeName
        btn_isTimeout.setTitle(data.timeOutLable, for: .normal)
        btn_Time.setTitle(data.timeOutLableVelue, for: .normal)
        btn_state.setTitle(data.orderStatName, for: .normal)
        
        if data.isUrgent == "1"{
            width_btn_isUrgent.constant = 40
            btn_isUrgent.isHidden = false
        }else{
            width_btn_isUrgent.constant = 0
            btn_isUrgent.isHidden = true
        }
        
        btn_isTimeout.isHidden = data.timeOutLable == ""
        btn_Time.isHidden = data.timeOutLableVelue == ""
        
        if data.timeOutLable == "超时"{
            btn_isTimeout.backgroundColor = UIColor(hexString: "FF6300")
        }else{
            btn_isTimeout.backgroundColor = UIColor(hexString: "009DA1")
        }
        //机型
        lab_item.text = data.categoryName
        //地址
        lab_address.text = data.userAddress
        //用户
        lab_userInfo.text = data.userName+" " +  data.userMobile
        //工单时间
        lab_orderInfo.text = data.timeLable
        
        switch self.searchType {
        case 1:
            btn_action.setTitle("确认接单".languageString(), for: .normal)
            btn_action.isHidden = false
        case 3,41:
            btn_action.setTitle("派工".languageString(), for: .normal)
            btn_action.isHidden = false
        default:
            btn_action.isHidden = true
            break
        }
        
        if [1,3,41].contains(searchType){
            bottomView.isHidden = false
        }else{
            bottomView.isHidden = true
        }
    }
    
}
