//
//  HomePagingListOrderHeaderView.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/13.
//

import UIKit

class HomePagingListOrderHeaderView: UIView {
    lazy var bannerView: SDCycleScrollView = {
        let theBannerView = SDCycleScrollView(frame:CGRect.init(x: 0, y: 0, width: SCREEN_W-30, height: 200))
        theBannerView.backgroundColor = UIColor(hexString: "f8f8f8")
        theBannerView.clickItemOperationBlock = { (index)  in
            
        }
        return theBannerView
    }()
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var view_banner: UIView!
    //消息
    @IBOutlet weak var messageView: UIView!
    @IBOutlet weak var view_message1: UIView!
    @IBOutlet weak var lab_message1: UILabel!
    @IBOutlet weak var view_message2: UIView!
    @IBOutlet weak var lab_message2: UILabel!
    
    @IBOutlet weak var view_point1: UIView!
    @IBOutlet weak var view_point2: UIView!
    @IBOutlet weak var lab_newsCount: UILabel!
    
    var banners = [String]()
    
    var callback:(()->())?
    override func awakeFromNib() {
        super.awakeFromNib()

        bgView.backgroundColor = UIColor(hexString: "f9f9f9")
        view_banner.backgroundColor = UIColor(hexString: "f9f9f9")
        view_banner.addSubview(bannerView)
        bannerView.pageDotColor = UIColor(hexString: "#ffffff")
        bannerView.currentPageDotColor = UIColor(hexString: "#478BFF")
        bannerView.snp_makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
        }
        
        let tap1 = UITapGestureRecognizer(target: self, action: #selector(messageClick(_:)))
        messageView.addGestureRecognizer(tap1)
    }
    
    @objc func messageClick(_ sender:UITapGestureRecognizer){
        callback?()
    }

    // MARK: - cycleView
    func setWithArr(){
        if banners.count == 0{
            self.setNormal()
            return
        }
        
        if banners.count == 1{
            bannerView.autoScroll = false
        }
        bannerView.imageURLStringsGroup = banners
        bannerView.autoScrollTimeInterval = 6
        bannerView.bannerImageViewContentMode = .scaleToFill
        
        if banners.count>1{
            bannerView.autoScroll = true
        }else{
            bannerView.autoScroll = false
        }
        
    }
    
    func setNormal(){
        bannerView.localizationImageNamesGroup = ["bg"]
        bannerView.autoScrollTimeInterval = 4
        bannerView.backgroundColor = UIColor.white
//        bannerView.placeholderImage = UIImage(named: "bg")
        bannerView.bannerImageViewContentMode = .scaleToFill
        if bannerView.localizationImageNamesGroup.count>1{
            bannerView.autoScroll = true
        }else{
            bannerView.autoScroll = false
        }
    }
    
    // mark - SDCycleScrollViewDelegate
    func cycleScrollView(_ cycleScrollView: SDCycleScrollView!, didScrollTo index: Int) {
        
    }
    
    func cycleScrollView(_ cycleScrollView: SDCycleScrollView!, didSelectItemAt index: Int) {

    }
    
    func row_update(dataSource data: (HomeModel)) {
        
        var banners = [String]()

        if data.appbarner1 != ""{banners.append(data.appbarner1)}
        if data.appbarner2 != ""{banners.append(data.appbarner2)}
        if data.appbarner3 != ""{banners.append(data.appbarner3)}
        
        self.banners = banners
        self.setWithArr()
        
        //消息
        lab_newsCount.text = data.unReadMessageQty
        lab_newsCount.isHidden = data.unReadMessageQty == ""
        lab_newsCount.isHidden = data.unReadMessageQty == "0"
        
        lab_message1.isHidden = true
        lab_message2.isHidden = true
        view_point1.isHidden = true
        view_point2.isHidden = true
        
        for (index,item) in data.messages.enumerated() {
            switch index {
            case 0:
                lab_message1.text = item.content
                lab_message1.isHidden = false
                view_point1.isHidden = false
            case 1:
                lab_message2.text = item.content
                lab_message2.isHidden = false
                view_point2.isHidden = false
            default:
               break
            }
        }
    }
}
