//
//  HomeMessageListVm.swift
//  Service
//
//  Created by Jan on 2023/7/19.
//  Copyright © 2023 yus. All rights reserved.
//

import UIKit

class HomeMessageListVm: NSObject {

    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var dataArray = [[String:Any]]()
    var disSelectCallback:(([String:Any])->())?
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []

        newForms += makeInfoForms()
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []

        guard dataArray.count > 0 else {
            return []
        }
      
        
        for item in dataArray {
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (15, 15, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
                newForms.append(rowCell)
            }
            
            do {
                let title = item.stringValue(forKey: "title")
                let dateStr = item.stringValue(forKey: "createTime")
                let readStat = item.stringValue(forKey: "readStat")
                let isRead = readStat == "1"
                
                
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(15).setBgViewTrailing(15).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title(title)
                    .titleFont(UIFont.boldSystemFont(ofSize: 15))
                    .titleColor(UIColor(hexString: "#333333"))
                    .showIconView(!isRead)
                    .infoColor(UIColor(hexString: "#ABADAD"))
                    .showNext(false)
                    .showLine(false)
                    .textAlignment(.right)
                
                let rowCell = TCFormCellModel<Cell_HomeMessageHeader>.init(data: (120, dateStr, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                    guard let weakSelf = self else { return }
                  
                })
                newForms.append(rowCell)
            }
            
            do {
                let value = item.stringValue(forKey: "content")
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(15).setBgViewTrailing(15).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title(value)
                    .titleFont(UIFont.systemFont(ofSize: 14))
                    .titleColor(UIColor(hexString: "#666666"))
                    .showNext(false)
                    .showLine(true)
                    .textAlignment(.left)
                let rowCell = TCFormCellModel<TCLabelCell>.init(data: (SCREEN_W-30, "", ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                    guard let weakSelf = self else { return }
                  
                })
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(15).setBgViewTrailing(15).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title("查看详情".languageString())
                    .titleFont(UIFont.systemFont(ofSize: 14))
                    .titleColor(UIColor(hexString: "#999999"))
                    .showNext(true)
                    .showLine(false)
                    .textAlignment(.left)
                let rowCell = TCFormCellModel<TCLabelCell>.init(data: (SCREEN_W-30, "", ""), config: uiConfigModel, id: nil, frameh: 40, didSelect:  { [weak self] in
                    guard let weakSelf = self else { return }
                    weakSelf.disSelectCallback?(item)
                })
                newForms.append(rowCell)
            }
            
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (15, 15, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
        }

        
       return newForms
    }
}
