//
//  HomeOrderListVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/25.
//

import UIKit
class HomeOrderListVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    
    var orderLists = [HomeModel.HomeOrder]()
    
    var searchKey = ""
    var model = HomeModel(json: [:])
    var callback:(()->())?
    var disSelectOrderCallback:((String)->())?
    var reloadOrderCallback:(()->())?
    
    var jumpOrderCallback:(()->())?
    
    var selectedIndex = 0 //默认没说
    var searchType = 1
    func makeForms(){
        var newForms:[TCCellBaseProtocol] = []
        newForms += makeHeaderForms()
        newForms += makeOnDoorOrderForms()
        newForms += makeOrderListForms()
        
        forms = newForms
        callback?()
    }
    
    
    func makeHeaderForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_OrderListHomeHeader>.init(data: (model), config: uiConfigModel, id: nil, frameh: 200) { a in
                if let type = a as? Int {
                    self.searchKey = ""
                    self.searchType = type
                    self.jumpOrderCallback?()
                }
               
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 20)
            newForms.append(rowCell)
        }
        return newForms
    }
    
    //待上门服务工单
    func makeOnDoorOrderForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []

        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .showLine(false)
            let rowCell = TCFormCellModel<Cell_HomeTitleHeader>.init(data: ("待上门服务工单".languageString()), config: uiConfigModel, id: nil, frameh: 30)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        //内容
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .showLine(false)
            let rowCell = TCFormCellModel<Cell_HomeDays>.init(data: (model,selectedIndex), config: uiConfigModel, id: nil, frameh: 80,callBack: { [weak self] callValue in
                if let actionTag = callValue as? (String,Int){
                    self?.searchKey = actionTag.0
                    self?.searchType = 4
                    self?.selectedIndex = actionTag.1
                    self?.reloadOrderCallback?()
                }
            })
            newForms.append(rowCell)
        }
        
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        return newForms
    }
    
    
    func makeOrderListForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        
        guard self.orderLists.count != 0 else {
            return []
        }

        
        for item in orderLists {
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (15, 15, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
                newForms.append(rowCell)
            }
            
            //内容
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_HomeOrderListHeader>.init(data: (item), config: uiConfigModel, id: nil, frameh: 40, didSelect:  {[weak self] in
                    //查看详情
                    guard let weakSelf = self else { return }
                    let model = item
                    weakSelf.disSelectOrderCallback?(model.orderId)
                   
                })
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .showLine(false)
                    .title(item.categoryName)
                    .bgColor(UIColor(hexString: "f8f8f8"))
                    .titleFont(UIFont.systemFont(ofSize: 15))
                    .titleColor(UIColor(hexString: "333333"))
                let rowCell = TCFormCellModel<TCTextLineCell>.init(data: (SCREEN_W-30, "", "",15,15), config: uiConfigModel, id: nil, frameh: 30, didSelect:  {[weak self] in
                    //查看详情
                    guard let weakSelf = self else { return }
                    let model = item
                    weakSelf.disSelectOrderCallback?(model.orderId)
                })
                newForms.append(rowCell)
            }
            
            do {
                let cfModel = TCFormCellConfigModel(titleStr: "GPS").showTip(false).setBgViewLeading(15).setBgViewTrailing(15).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title(item.userAddress)
                    .titleColor(UIColor(hexString: "#333333"))
                    .titleAlignment(.left)
                    .textAlignment(.left)
                    .canEdit(false)
                    .showTip(false)
                    .showNext(true)
                    .showLine(false)
                    .nextImageStr("detail_icon_address")
                let rowCell = TCFormCellModel<Cell_HomeOrderListAddress>.init(data: (SCREEN_W-30, "", ""), config: cfModel, id: nil, frameh: 40,callBack: { a in
                    //定位导航
                    let mapM  = MapModel()
                    mapM.lat = item.lat
                    mapM.lng = item.lnt
                    mapM.userAddress = item.userAddress
                    
                    MapsTool.shareInstance().mapAction(mapM)
                    
                }, didSelect:  { [weak self] in
                    //查看详情
                    guard let weakSelf = self else { return }
                    let model = item
                    weakSelf.disSelectOrderCallback?(model.orderId)
                })
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_HomeOrderListLine>.init(data: (item,1), config: uiConfigModel, id: nil, frameh: 30,callBack: { t in
                    //拨打电话
                    CD.visibleVC?.callUserPhone(item.userMobile, orderId: item.orderId)
//                    CD.visibleVC?.callPhone(item.userMobile,orderid: item.orderId)
                }, didSelect:  {[weak self] in
                    //查看详情
                    guard let weakSelf = self else { return }
                    let model = item
                    weakSelf.disSelectOrderCallback?(model.orderId)
                })
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_HomeOrderListLine>.init(data: (item,2), config: uiConfigModel, id: nil, frameh: 30, didSelect:  {[weak self] in
                    //查看详情
                    guard let weakSelf = self else { return }
                    let model = item
                    weakSelf.disSelectOrderCallback?(model.orderId)
                })
                newForms.append(rowCell)
            }
         
            /*
            //新单 和待派单有工单操作
            if [1,3,41].contains(searchType){
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    let rowCell = TCFormCellModel<Cell_HomeOrderListBottomAction>.init(data: (item,searchType), config: uiConfigModel, id: nil, frameh: 50, didSelect:  {
                        //查看消息详情
                        let model = item
                        
                    })
                    newForms.append(rowCell)
                }
            }
             
             */
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            
        }
        
        
        return newForms
    }
}
