//
//  HomeVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/23.
//

import UIKit

class HomeVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    
    var showMessageCallback:(()->())?
    var reloadOrderListCallback:((Int)->())?
    var disSelectOrderCallback:((String)->())?
    var orderActionCallback:((String,String)->())?
    var model = HomeModel(json: [:])
    var oldOrderLists = [HomeModel.HomeOrder]()
    var searchType = 1
    
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []
        newForms += makeBannerForms()
        newForms += makeMessageForms()
        newForms += makeOrderActionForms()
        newForms += makeOrderListForms()
    
        forms = newForms
        callback?()
    }
    
    func makeBannerForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            var banners = [String]()
            if model.appbarner1 != ""{banners.append(model.appbarner1)}
            if model.appbarner2 != ""{banners.append(model.appbarner2)}
            if model.appbarner3 != ""{banners.append(model.appbarner3)}
            
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_HomePageBanner>.init(data: (banners), config: uiConfigModel, id: nil, frameh: 155) { a in
                if let actionStr = a as? String {
                    //跳转xx
                }
               
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        return newForms
    }
    
    func makeMessageForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []

        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (15, 15, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .showLine(false)
            let rowCell = TCFormCellModel<Cell_HomeMessage>.init(data: (model), config: uiConfigModel, id: nil, frameh: 66, didSelect:  {
                //查看更多消息
                self.showMessageCallback?()
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (15, 15, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        
        return newForms
    }
    
    func makeOrderActionForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_HomeOrderAction>.init(data: (model), config: uiConfigModel, id: nil, frameh: 50) { a in
                if let type = a as? Int {
                    if type == 0{
                        //全部
                        self.reloadOrderListCallback?(0)
                    }else{
                        //刷新工单
                        if type != self.searchType {
                            /*
                            self.model.orderLists.removeAll()
                            self.makeForms()
                            */
                            
                            self.searchType = type
                            self.reloadOrderListCallback?(self.searchType)
                        }
                    }
                   
                }
               
            }
            newForms.append(rowCell)
        }
        
//        do {
//            let uiConfigModel = TCFormCellConfigModel.defaultModel()
//                .bgColor(.clear)
//                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
//                .cornerRadius(8)
//            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 5)
//            newForms.append(rowCell)
//        }
        return newForms
    }
    
    
    func makeOrderListForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        
        guard model.orderLists.count != 0 else {
            return []
        }

        
        for item in model.orderLists {
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (15, 15, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
                newForms.append(rowCell)
            }
            
            //内容
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_HomeOrderListHeader>.init(data: (item), config: uiConfigModel, id: nil, frameh: 40, didSelect:  {  [weak self] in
                    //查看详情
                    guard let weakSelf = self else { return }
                    let model = item
                    weakSelf.disSelectOrderCallback?(model.orderId)
                })
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .showLine(false)
                    .title(item.categoryName)
                    .bgColor(UIColor(hexString: "f8f8f8"))
                    .titleFont(UIFont.systemFont(ofSize: 15))
                    .titleColor(UIColor(hexString: "333333"))
                let rowCell = TCFormCellModel<TCTextLineCell>.init(data: (SCREEN_W-30, "", "",15,15), config: uiConfigModel, id: nil, frameh: 30, didSelect:  { [weak self] in
                    debugPrint("点击了~~~")
                    guard let weakSelf = self else { return }
                    let model = item
                    weakSelf.disSelectOrderCallback?(model.orderId)
                })
                newForms.append(rowCell)
            }
            
            do {
                let cfModel = TCFormCellConfigModel(titleStr: "GPS").showTip(false).setBgViewLeading(15).setBgViewTrailing(15).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title(item.userAddress)
                    .titleColor(UIColor(hexString: "#333333"))
                    .titleAlignment(.left)
                    .textAlignment(.left)
                    .canEdit(false)
                    .showTip(false)
                    .showNext(true)
                    .showLine(false)
                    .nextImageStr("detail_icon_address")
                let rowCell = TCFormCellModel<Cell_HomeOrderListAddress>.init(data: (SCREEN_W-30, "", ""), config: cfModel, id: nil, frameh: 40,callBack: { a in
                    //定位导航
                    let mapM  = MapModel()
                    mapM.lat = item.lat
                    mapM.lng = item.lnt
                    mapM.userAddress = item.userAddress
                    
                    MapsTool.shareInstance().mapAction(mapM)
                    
                }, didSelect:  { [weak self] in
                    guard let weakSelf = self else { return }
                    let model = item
                    weakSelf.disSelectOrderCallback?(model.orderId)
                })
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_HomeOrderListLine>.init(data: (item,1), config: uiConfigModel, id: nil, frameh: 30,callBack: { t in
                    //拨打电话
                    CD.visibleVC?.callUserPhone(item.userMobile, orderId: item.orderId)
//                    CD.visibleVC?.callPhone(item.userMobile,orderid: item.orderId)
                }, didSelect:  {  [weak self] in
                    //查看详情
                    guard let weakSelf = self else { return }
                    let model = item
                    weakSelf.disSelectOrderCallback?(model.orderId)
                   
                })
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_HomeOrderListLine>.init(data: (item,2), config: uiConfigModel, id: nil, frameh: 30, didSelect:  {  [weak self] in
                    //查看详情
                    guard let weakSelf = self else { return }
                    let model = item
                    weakSelf.disSelectOrderCallback?(model.orderId)
                   
                })
                newForms.append(rowCell)
            }
            
            //新单 和待派单有工单操作,企业用户没有 待接单
            if [1,3,41].contains(searchType){
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    let rowCell = TCFormCellModel<Cell_HomeOrderListBottomAction>.init(data: (item,searchType), config: uiConfigModel, id: nil, frameh: 50,callBack: { [weak self](actionTag) in
                        guard let weakSelf = self else { return }
                        if let theTagStr = actionTag as? String {
                            weakSelf.orderActionCallback?(theTagStr,item.orderId)
                        }
                        
                    }, didSelect:  {[weak self] in
                        //查看详情
                        guard let weakSelf = self else { return }
                        let model = item
                        weakSelf.disSelectOrderCallback?(model.orderId)
                        
                    })
                    newForms.append(rowCell)
                }
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            
        }
        
        
        return newForms
    }
    
}
