
import UIKit

/// 用户类型:0工程师,1服务商,2企业用户;
enum UserRole: Int {
    case None = -99
    case Engineer = 0
    case Site = 1
    case Admin = 2
}

class MyInfo: NSObject {
    // 用户
    var userId = ""
    var userName = ""
    // 企业
    var companyId = ""
    var companyName = ""
    // 网点
    var siteId = ""
    var siteName = ""
    // 企业 id
    var adminId = ""
    // 工程师 id
    var engineerId = ""
    // 配置信息
    var userPic = ""
    var token = ""
    var APPFLAG = ""
    var userLevel = ""
    var requestUrl = ""
    var uploadServerAddress = ""
    // 推送
    var pushToken = ""
    // 角色
    var userRole = UserRole.None
    
    //线上最新版本
    var iosversion = ""
    //显示可更新红点
    var downloadShow = ""
}

// func
extension MyInfo {
    // 配置数据
    func configData(cData:[String:Any]) {
        userId = cData.stringValue(forKey: "userId")
        userName = cData.stringValue(forKey: "userName")
        companyId = cData.stringValue(forKey: "companyId")
        companyName = cData.stringValue(forKey: "companyName")
        siteId = cData.stringValue(forKey: "siteId")
        siteName = cData.stringValue(forKey: "siteName")
        adminId = cData.stringValue(forKey: "adminId")
        engineerId = cData.stringValue(forKey: "engineerId")
        userPic = cData.stringValue(forKey: "userPic")
        APPFLAG = cData.stringValue(forKey: "APPFLAG")
        token = cData.stringValue(forKey: "token")
        userLevel = cData.stringValue(forKey: "userLevel")
        requestUrl = cData.stringValue(forKey: "requestUrl")
        
        let uploadServerUrl = cData.stringValue(forKey: "uploadServerAddress")
        if uploadServerUrl.last == "/"{
            ///去掉/
            let newUrl = uploadServerUrl.prefix(uploadServerUrl.count-1)
            uploadServerAddress = String(newUrl)
        }else{
            uploadServerAddress = cData.stringValue(forKey: "uploadServerAddress")
        }
        
       
        setupRequestBaseData()
    }
    // 重置数据
    func resetData() {
        iosversion = ""
        downloadShow = ""
    }
    // 设置基础参数
    func setupRequestBaseData() {
        var baseParam = [String:Any]()
        baseParam["companyId"] = companyId
        baseParam["userId"] = userId
        baseParam["userName"] = userName
        baseParam["siteId"] = siteId
        baseParam["engineerId"] = engineerId
        baseParam["adminId"] = adminId
        baseParam["userRole"] = userRole.rawValue
        
        TWOCNetwork.shareNetManager().baseParameters = baseParam
        TWOCNetwork.shareNetManager().httpHeaders = ["Authorization":"Bearer "+token]
    }
}

extension MyInfo {
    // 单例
    private static let once = MyInfo()
    class var sole:MyInfo {
        get {
            return once
        }
    }
    @objc class func shareInstance() -> MyInfo{
        return MyInfo.sole
    }
}
