//
//  RegisterVc.swift
//  VattiCSS
//
//  Created by Jan on 2024/2/3.
//

import UIKit

public struct R_Register {
    static func router() {
        let vc = RegisterVc.cd_storyboard("Login", from: "RegisterVc") as! RegisterVc
        vc.hidesBottomBarWhenPushed = true
        CD.push(vc)
    }
}

class RegisterVc: UIViewController {
    lazy var topBar: CD_TopBar = {
        return CD_TopBar()
    }()
    lazy var tableView: UITableView = {
        let tab = UITableView()
        return tab
    }()
    var vm = RegisterVm()
  
    deinit {
        
    }
    override func viewDidLoad() {
        super.viewDidLoad()

        self.cd.navigationBar(hidden: true)
        self.view.cd
            .add(topBar)
        topBar.delegate = self
        topBar.snp.makeConstraints { (make) in
            make.left.top.right.equalToSuperview()
        }
        
        self.configTableView()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)

    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
        
        MineGetCodeTool.defaultTool().timerNumber = 0
    }
    
    func configTableView() {
        view.addSubview(tableView)
        tableView.snp.makeConstraints { (make) in
            make.top.equalTo(self.topBar.snp.bottom)
            make.left.right.bottom.equalToSuperview()
        }
        
        self.tableView.backgroundColor = UIColor(hexString: "f8f8f8")
        self.view.backgroundColor = UIColor(hexString: "f8f8f8")
        
        if #available(iOS 15.0, *) {
            tableView.sectionHeaderTopPadding = 0
        }
        tableView.delegate = self
        tableView.dataSource = self
        tableView.separatorStyle = .none
       
        vm.callback = {
            self.tableView.reloadData()
        }
        
        vm.submitCallback = {
            self.checkParam()
        }
        
        vm.makeForms()
    }
    
    func checkParam() {
        guard vm.mobile != "" else {
            CD.visibleVC?.promptInformation("请输入".languageString()+"手机号".languageString())
            return
        }
        guard vm.password1 != "" else {
            CD.visibleVC?.promptInformation("请输入密码".languageString())
            return
        }
        
        guard vm.password1.count >= 6 else {
            CD.visibleVC?.promptInformation("密码不能小于6位！".languageString())
            return
        }
        guard vm.password2 != "" else {
            CD.visibleVC?.promptInformation("请再次输入新密码".languageString())
            return
        }
        guard vm.password1 == vm.password2 else {
            CD.visibleVC?.promptInformation("前后新密码不一致，请重新输入".languageString())
            return
        }
        
        var param = [String:Any]()
        param["newMobile"] = vm.mobile
        param["password"] = vm.password1
        requstSaveData(param)
    }
}

//请求
extension RegisterVc{
    func requstSaveData(_ param:[String:Any]){
        var requestPath = "https://fwptcloud.5mall.com/app/v2/login/register"
        
        let cNet = TWOCNetwork(url: requestPath,andParam: param)
        cNet.successCall = { [weak self] (result) in
            guard let weakSelf = self else { return }
            
            hud_info("注册".languageString()+"操作成功~".languageString())
            DispatchQueue.main.asyncAfter(deadline: .now() + 1) {
                weakSelf.navigationController?.popViewController(animated: true)
            }
        }
        cNet.failCall = {(errorTag,errorStr) in
            hud_error(errorStr)
        }
        cNet.sendRegisterRequest()
    }
}


extension RegisterVc: CD_TopBarProtocol {
    func topBarCustom() {
        topBar.cd.background(.white)
        topBar._title = "注册".languageString()
        topBar._colorTitle = Config.color.hex("3")
        topBar.bar_navigation.line.cd.isHidden(true)
        
        topBar._style = "10"
    }
    
    func update(withTopBar item: CD_TopNavigationBar.Item) -> [CD_TopNavigationBarItem.Item.Style]? {
        switch item {
        case .leftItem1:
            let color:UIColor = Config.color.hex("6")
            let icon = CD_IconFont.tback_light(22)
            return [.title([(icon.text, icon.font, color, .normal), (icon.text, icon.font, Config.color.hex("6"), .highlighted), (icon.text, icon.font, Config.color.hex("6"), .selected)])]
        default:
            return nil
        }
    }
    
    func didSelect(withTopBar item: CD_TopNavigationBar.Item) {
        super_topBarClick(item)
        switch item {
        case .leftItem1:
            break
        default:
            break
        }
    }
}


// MARK: - Table view data source
extension RegisterVc: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return vm.forms.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cellVM = vm.forms[indexPath.row]
        let cellIdentifier = cellVM.cellId.isEmpty ? String(describing: cellVM.cellClass) : cellVM.cellId
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        if cell == nil {
            let bundle = Bundle.main.path(forResource:cellIdentifier, ofType: "nib")
            if bundle == nil{
                tableView.register(cellVM.cellClass, forCellReuseIdentifier: cellIdentifier)
            }else{
                let cellNib = UINib(nibName:cellIdentifier, bundle: nil)
                tableView.register(cellNib, forCellReuseIdentifier: cellIdentifier)
            }
            cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        }
        
        guard let endCell = cell else {
            fatalError("没有找到标识为：\(cellIdentifier)的Cell")
        }
        cellVM.bind(endCell)
        return endCell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        view.backgroundColor = UIColor.init(hexString: "f8f8f8")
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, estimatedHeightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        let cellVM = vm.forms[indexPath.row]
        return cellVM.frameH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cellVM = vm.forms[indexPath.row]
        cellVM.tapBlock?()
    }
}
