//
//  RegisterVm.swift
//  VattiCSS
//
//  Created by Jan on 2024/2/3.
//

import UIKit

class RegisterVm: NSObject {
    
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var submitCallback:(()->())?

    var mobile = ""
    var password1 = ""
    var password2 = ""
    
    func makeForms(){
        var newForms:[TCCellBaseProtocol] = []
        newForms += makeAccountForms()
    
        forms = newForms
        callback?()
    }
    
    func makeAccountForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
    
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "注册账号".languageString()).showTip(false).setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, mobile, "请输入".languageString(), nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.mobile = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        //密码
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "输入密码".languageString()).showTip(false).setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, password1, "请输入".languageString(), nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.password1 = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "确认密码").showTip(false).setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, password2, "请输入".languageString(), nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.password2 = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
       
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 30)
            newForms.append(rowCell)
        }
        
        //保存按钮TCSubmitButtonCell
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().bgColor(UIColor(hexString: "f8f8f8")).setCellColor(UIColor(hexString: "f8f8f8"))
            let rowCell = TCFormCellModel<TCSubmitButtonCell>.init(data: (false, "","提交".languageString(), UIColor(hexString: "ffffff"), 60, nil), config: uiConfigModel, id: nil, frameh: 50) { a in
                //提交
                self.submitCallback?()
            }
            newForms.append(rowCell)
        }
        
       return newForms
    }
    
}
