//
//  Cell_InfoImage1.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/16.
//

import UIKit

class Cell_InfoImage1: UITableViewCell {
    @IBOutlet weak var bgView1: UIView!
    @IBOutlet weak var btn_add1: UIButton!
    @IBOutlet weak var img_1: UIImageView!

    @IBOutlet weak var bgView2: UIView!
    @IBOutlet weak var btn_add2: UIButton!
    @IBOutlet weak var img_2: UIImageView!
    
    
    @IBOutlet weak var lab_name1: UILabel!
    @IBOutlet weak var lab_name2: UILabel!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        
        let tap1 = UITapGestureRecognizer(target: self, action: #selector(imageChange(_:)))
        img_1.addGestureRecognizer(tap1)
        img_1.isUserInteractionEnabled = true
        
        let tap2 = UITapGestureRecognizer(target: self, action: #selector(imageChange(_:)))
        img_2.addGestureRecognizer(tap2)
        img_2.isUserInteractionEnabled = true
        
        
        lab_name1.text = "身份证正面".languageString()
        lab_name2.text = "身份证反面".languageString()
    }
    
    
    @objc func imageChange(_ sender:UITapGestureRecognizer){
        if sender.view == img_1{
            callBack?(1)
        } else if sender.view == img_2{
            callBack?(2)
        }
       
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    @IBAction func addAction(_ sender: UIButton) {
        callBack?(sender.tag)
    }
}

extension Cell_InfoImage1: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
       
    }
    
    func row_update(dataSource data: (String,String)) {
        if data.0 != ""{
            btn_add1.isHidden = true
            img_1.sd_setImage(with: URL(string: data.0))
            
        }else{
            img_1.sd_setImage(with: URL(string: ""))
            btn_add1.isHidden = false
        }
        
        if data.1 != ""{
            btn_add2.isHidden = true
            img_2.sd_setImage(with: URL(string: data.1))
        }else{
            btn_add2.isHidden = false
            img_2.sd_setImage(with: URL(string: ""))
        }
        
        img_1.layer.cornerRadius = 8
        img_1.layer.masksToBounds = true
        img_2.layer.cornerRadius = 8
        img_2.layer.masksToBounds = true
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}


